## RabbitMQ 3.8.30

RabbitMQ `3.8.30` is a maintenance release.
All users are recommended to upgrade to this release.

### Obtaining Packages

RabbitMQ releases are distributed via [GitHub](https://github.com/rabbitmq/rabbitmq-server/releases), [Cloudsmith](https://cloudsmith.io/~rabbitmq/repos/),
and [PackageCloud](https://packagecloud.io/rabbitmq).

### Erlang/OTP Compatibility Notes

This release [requires Erlang 23.2](https://www.rabbitmq.com/which-erlang.html) and [supports Erlang 24](https://blog.rabbitmq.com/posts/2021/03/erlang-24-support-roadmap/).

[Provisioning Latest Erlang Releases](https://www.rabbitmq.com/which-erlang.html#erlang-repositories) explains
what package repositories and tools can be used to provision modern Erlang versions.


## Upgrade and Compatibility Notes

See the [Upgrading guide](https://www.rabbitmq.com/upgrade.html) for general documentation on upgrades and
[RabbitMQ change log](https://www.rabbitmq.com/changelog.html) for release notes of other releases.

If upgrading from a `3.7.x` release, see [3.8.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.8.0)
upgrade and compatibility notes first.

If upgrading from a `3.6.x` or older [release series](https://www.rabbitmq.com/versions.html), first upgrade
to [`3.7.27`](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.7.27) and then to this version.


## Getting Help

Any questions about this release, upgrades or RabbitMQ in general are welcome on the [RabbitMQ mailing list](https://groups.google.com/forum/#!forum/rabbitmq-users)
and [RabbitMQ community Slack](https://rabbitmq-slack.herokuapp.com/).


## Changes Worth Mentioning

Release notes are kept under [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.8.x/release-notes).
Contributors are encouraged to update them together with their changes.  This helps with release automation and more
consistent release schedule.


### Core Server

#### Enhancements

 * Significantly faster queue re-import from [definitions](https://rabbitmq.com/definitions.html)
   on subsequent node restarts. Initial definition import still takes
   the same amount of time as before.

   GitHub issue: [#4538](https://github.com/rabbitmq/rabbitmq-server/pull/4538)

 * Significantly faster exchange re-import from [definitions](https://rabbitmq.com/definitions.html)
   on subsequent node restarts. Initial definition import still takes
   the same amount of time as before.

   GitHub issue: [#4585](https://github.com/rabbitmq/rabbitmq-server/pull/4585)

#### Bug Fixes

 * `rabbitmq-upgrade await_online_synchronized_mirror` is now a no-op in single node
   clusters

   GitHub issue: [#4570](https://github.com/rabbitmq/rabbitmq-server/pull/4570)



## Dependency Upgrades

* `observer-cli` was upgraded [from v1.7.2 to v1.7.3](https://github.com/zhongwencool/observer_cli/compare/1.7.2...1.7.3)


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.8.30.tar.xz`
instead of the source tarball produced by GitHub.

