/****************************************************************************
**
** Copyright (C) 2015 The Qt Company Ltd.
** Contact: http://www.qt.io/licensing/
**
** This file is part of the QtCore module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL21$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see http://www.qt.io/terms-conditions. For further
** information use the contact form at http://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 or version 3 as published by the Free
** Software Foundation and appearing in the file LICENSE.LGPLv21 and
** LICENSE.LGPLv3 included in the packaging of this file. Please review the
** following information to ensure the GNU Lesser General Public License
** requirements will be met: https://www.gnu.org/licenses/lgpl.html and
** http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** As a special exception, The Qt Company gives you certain additional
** rights. These rights are described in The Qt Company LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** $QT_END_LICENSE$
**
****************************************************************************/
#include "Big5MapTable.h"

#include <type_traits>

// Big 5 to Unicode maping tables.
// Tables are in sorted order on X(all table together) & Y(individually)
static const B5Map b5_8140_to_uc_map[2041] = {
    {0x8140,0xeeb8}, {0x8141,0xeeb9}, {0x8142,0xeeba}, {0x8143,0xeebb}, {0x8144,0xeebc}, {0x8145,0xeebd}, {0x8146,0xeebe}, {0x8147,0xeebf}, {0x8148,0xeec0}, {0x8149,0xeec1},
    {0x814a,0xeec2}, {0x814b,0xeec3}, {0x814c,0xeec4}, {0x814d,0xeec5}, {0x814e,0xeec6}, {0x814f,0xeec7}, {0x8150,0xeec8}, {0x8151,0xeec9}, {0x8152,0xeeca}, {0x8153,0xeecb},
    {0x8154,0xeecc}, {0x8155,0xeecd}, {0x8156,0xeece}, {0x8157,0xeecf}, {0x8158,0xeed0}, {0x8159,0xeed1}, {0x815a,0xeed2}, {0x815b,0xeed3}, {0x815c,0xeed4}, {0x815d,0xeed5},
    {0x815e,0xeed6}, {0x815f,0xeed7}, {0x8160,0xeed8}, {0x8161,0xeed9}, {0x8162,0xeeda}, {0x8163,0xeedb}, {0x8164,0xeedc}, {0x8165,0xeedd}, {0x8166,0xeede}, {0x8167,0xeedf},
    {0x8168,0xeee0}, {0x8169,0xeee1}, {0x816a,0xeee2}, {0x816b,0xeee3}, {0x816c,0xeee4}, {0x816d,0xeee5}, {0x816e,0xeee6}, {0x816f,0xeee7}, {0x8170,0xeee8}, {0x8171,0xeee9},
    {0x8172,0xeeea}, {0x8173,0xeeeb}, {0x8174,0xeeec}, {0x8175,0xeeed}, {0x8176,0xeeee}, {0x8177,0xeeef}, {0x8178,0xeef0}, {0x8179,0xeef1}, {0x817a,0xeef2}, {0x817b,0xeef3},
    {0x817c,0xeef4}, {0x817d,0xeef5}, {0x817e,0xeef6}, {0x81a1,0xeef7}, {0x81a2,0xeef8}, {0x81a3,0xeef9}, {0x81a4,0xeefa}, {0x81a5,0xeefb}, {0x81a6,0xeefc}, {0x81a7,0xeefd},
    {0x81a8,0xeefe}, {0x81a9,0xeeff}, {0x81aa,0xef00}, {0x81ab,0xef01}, {0x81ac,0xef02}, {0x81ad,0xef03}, {0x81ae,0xef04}, {0x81af,0xef05}, {0x81b0,0xef06}, {0x81b1,0xef07},
    {0x81b2,0xef08}, {0x81b3,0xef09}, {0x81b4,0xef0a}, {0x81b5,0xef0b}, {0x81b6,0xef0c}, {0x81b7,0xef0d}, {0x81b8,0xef0e}, {0x81b9,0xef0f}, {0x81ba,0xef10}, {0x81bb,0xef11},
    {0x81bc,0xef12}, {0x81bd,0xef13}, {0x81be,0xef14}, {0x81bf,0xef15}, {0x81c0,0xef16}, {0x81c1,0xef17}, {0x81c2,0xef18}, {0x81c3,0xef19}, {0x81c4,0xef1a}, {0x81c5,0xef1b},
    {0x81c6,0xef1c}, {0x81c7,0xef1d}, {0x81c8,0xef1e}, {0x81c9,0xef1f}, {0x81ca,0xef20}, {0x81cb,0xef21}, {0x81cc,0xef22}, {0x81cd,0xef23}, {0x81ce,0xef24}, {0x81cf,0xef25},
    {0x81d0,0xef26}, {0x81d1,0xef27}, {0x81d2,0xef28}, {0x81d3,0xef29}, {0x81d4,0xef2a}, {0x81d5,0xef2b}, {0x81d6,0xef2c}, {0x81d7,0xef2d}, {0x81d8,0xef2e}, {0x81d9,0xef2f},
    {0x81da,0xef30}, {0x81db,0xef31}, {0x81dc,0xef32}, {0x81dd,0xef33}, {0x81de,0xef34}, {0x81df,0xef35}, {0x81e0,0xef36}, {0x81e1,0xef37}, {0x81e2,0xef38}, {0x81e3,0xef39},
    {0x81e4,0xef3a}, {0x81e5,0xef3b}, {0x81e6,0xef3c}, {0x81e7,0xef3d}, {0x81e8,0xef3e}, {0x81e9,0xef3f}, {0x81ea,0xef40}, {0x81eb,0xef41}, {0x81ec,0xef42}, {0x81ed,0xef43},
    {0x81ee,0xef44}, {0x81ef,0xef45}, {0x81f0,0xef46}, {0x81f1,0xef47}, {0x81f2,0xef48}, {0x81f3,0xef49}, {0x81f4,0xef4a}, {0x81f5,0xef4b}, {0x81f6,0xef4c}, {0x81f7,0xef4d},
    {0x81f8,0xef4e}, {0x81f9,0xef4f}, {0x81fa,0xef50}, {0x81fb,0xef51}, {0x81fc,0xef52}, {0x81fd,0xef53}, {0x81fe,0xef54}, {0x8240,0xef55}, {0x8241,0xef56}, {0x8242,0xef57},
    {0x8243,0xef58}, {0x8244,0xef59}, {0x8245,0xef5a}, {0x8246,0xef5b}, {0x8247,0xef5c}, {0x8248,0xef5d}, {0x8249,0xef5e}, {0x824a,0xef5f}, {0x824b,0xef60}, {0x824c,0xef61},
    {0x824d,0xef62}, {0x824e,0xef63}, {0x824f,0xef64}, {0x8250,0xef65}, {0x8251,0xef66}, {0x8252,0xef67}, {0x8253,0xef68}, {0x8254,0xef69}, {0x8255,0xef6a}, {0x8256,0xef6b},
    {0x8257,0xef6c}, {0x8258,0xef6d}, {0x8259,0xef6e}, {0x825a,0xef6f}, {0x825b,0xef70}, {0x825c,0xef71}, {0x825d,0xef72}, {0x825e,0xef73}, {0x825f,0xef74}, {0x8260,0xef75},
    {0x8261,0xef76}, {0x8262,0xef77}, {0x8263,0xef78}, {0x8264,0xef79}, {0x8265,0xef7a}, {0x8266,0xef7b}, {0x8267,0xef7c}, {0x8268,0xef7d}, {0x8269,0xef7e}, {0x826a,0xef7f},
    {0x826b,0xef80}, {0x826c,0xef81}, {0x826d,0xef82}, {0x826e,0xef83}, {0x826f,0xef84}, {0x8270,0xef85}, {0x8271,0xef86}, {0x8272,0xef87}, {0x8273,0xef88}, {0x8274,0xef89},
    {0x8275,0xef8a}, {0x8276,0xef8b}, {0x8277,0xef8c}, {0x8278,0xef8d}, {0x8279,0xef8e}, {0x827a,0xef8f}, {0x827b,0xef90}, {0x827c,0xef91}, {0x827d,0xef92}, {0x827e,0xef93},
    {0x82a1,0xef94}, {0x82a2,0xef95}, {0x82a3,0xef96}, {0x82a4,0xef97}, {0x82a5,0xef98}, {0x82a6,0xef99}, {0x82a7,0xef9a}, {0x82a8,0xef9b}, {0x82a9,0xef9c}, {0x82aa,0xef9d},
    {0x82ab,0xef9e}, {0x82ac,0xef9f}, {0x82ad,0xefa0}, {0x82ae,0xefa1}, {0x82af,0xefa2}, {0x82b0,0xefa3}, {0x82b1,0xefa4}, {0x82b2,0xefa5}, {0x82b3,0xefa6}, {0x82b4,0xefa7},
    {0x82b5,0xefa8}, {0x82b6,0xefa9}, {0x82b7,0xefaa}, {0x82b8,0xefab}, {0x82b9,0xefac}, {0x82ba,0xefad}, {0x82bb,0xefae}, {0x82bc,0xefaf}, {0x82bd,0xefb0}, {0x82be,0xefb1},
    {0x82bf,0xefb2}, {0x82c0,0xefb3}, {0x82c1,0xefb4}, {0x82c2,0xefb5}, {0x82c3,0xefb6}, {0x82c4,0xefb7}, {0x82c5,0xefb8}, {0x82c6,0xefb9}, {0x82c7,0xefba}, {0x82c8,0xefbb},
    {0x82c9,0xefbc}, {0x82ca,0xefbd}, {0x82cb,0xefbe}, {0x82cc,0xefbf}, {0x82cd,0xefc0}, {0x82ce,0xefc1}, {0x82cf,0xefc2}, {0x82d0,0xefc3}, {0x82d1,0xefc4}, {0x82d2,0xefc5},
    {0x82d3,0xefc6}, {0x82d4,0xefc7}, {0x82d5,0xefc8}, {0x82d6,0xefc9}, {0x82d7,0xefca}, {0x82d8,0xefcb}, {0x82d9,0xefcc}, {0x82da,0xefcd}, {0x82db,0xefce}, {0x82dc,0xefcf},
    {0x82dd,0xefd0}, {0x82de,0xefd1}, {0x82df,0xefd2}, {0x82e0,0xefd3}, {0x82e1,0xefd4}, {0x82e2,0xefd5}, {0x82e3,0xefd6}, {0x82e4,0xefd7}, {0x82e5,0xefd8}, {0x82e6,0xefd9},
    {0x82e7,0xefda}, {0x82e8,0xefdb}, {0x82e9,0xefdc}, {0x82ea,0xefdd}, {0x82eb,0xefde}, {0x82ec,0xefdf}, {0x82ed,0xefe0}, {0x82ee,0xefe1}, {0x82ef,0xefe2}, {0x82f0,0xefe3},
    {0x82f1,0xefe4}, {0x82f2,0xefe5}, {0x82f3,0xefe6}, {0x82f4,0xefe7}, {0x82f5,0xefe8}, {0x82f6,0xefe9}, {0x82f7,0xefea}, {0x82f8,0xefeb}, {0x82f9,0xefec}, {0x82fa,0xefed},
    {0x82fb,0xefee}, {0x82fc,0xefef}, {0x82fd,0xeff0}, {0x82fe,0xeff1}, {0x8340,0xeff2}, {0x8341,0xeff3}, {0x8342,0xeff4}, {0x8343,0xeff5}, {0x8344,0xeff6}, {0x8345,0xeff7},
    {0x8346,0xeff8}, {0x8347,0xeff9}, {0x8348,0xeffa}, {0x8349,0xeffb}, {0x834a,0xeffc}, {0x834b,0xeffd}, {0x834c,0xeffe}, {0x834d,0xefff}, {0x834e,0xf000}, {0x834f,0xf001},
    {0x8350,0xf002}, {0x8351,0xf003}, {0x8352,0xf004}, {0x8353,0xf005}, {0x8354,0xf006}, {0x8355,0xf007}, {0x8356,0xf008}, {0x8357,0xf009}, {0x8358,0xf00a}, {0x8359,0xf00b},
    {0x835a,0xf00c}, {0x835b,0xf00d}, {0x835c,0xf00e}, {0x835d,0xf00f}, {0x835e,0xf010}, {0x835f,0xf011}, {0x8360,0xf012}, {0x8361,0xf013}, {0x8362,0xf014}, {0x8363,0xf015},
    {0x8364,0xf016}, {0x8365,0xf017}, {0x8366,0xf018}, {0x8367,0xf019}, {0x8368,0xf01a}, {0x8369,0xf01b}, {0x836a,0xf01c}, {0x836b,0xf01d}, {0x836c,0xf01e}, {0x836d,0xf01f},
    {0x836e,0xf020}, {0x836f,0xf021}, {0x8370,0xf022}, {0x8371,0xf023}, {0x8372,0xf024}, {0x8373,0xf025}, {0x8374,0xf026}, {0x8375,0xf027}, {0x8376,0xf028}, {0x8377,0xf029},
    {0x8378,0xf02a}, {0x8379,0xf02b}, {0x837a,0xf02c}, {0x837b,0xf02d}, {0x837c,0xf02e}, {0x837d,0xf02f}, {0x837e,0xf030}, {0x83a1,0xf031}, {0x83a2,0xf032}, {0x83a3,0xf033},
    {0x83a4,0xf034}, {0x83a5,0xf035}, {0x83a6,0xf036}, {0x83a7,0xf037}, {0x83a8,0xf038}, {0x83a9,0xf039}, {0x83aa,0xf03a}, {0x83ab,0xf03b}, {0x83ac,0xf03c}, {0x83ad,0xf03d},
    {0x83ae,0xf03e}, {0x83af,0xf03f}, {0x83b0,0xf040}, {0x83b1,0xf041}, {0x83b2,0xf042}, {0x83b3,0xf043}, {0x83b4,0xf044}, {0x83b5,0xf045}, {0x83b6,0xf046}, {0x83b7,0xf047},
    {0x83b8,0xf048}, {0x83b9,0xf049}, {0x83ba,0xf04a}, {0x83bb,0xf04b}, {0x83bc,0xf04c}, {0x83bd,0xf04d}, {0x83be,0xf04e}, {0x83bf,0xf04f}, {0x83c0,0xf050}, {0x83c1,0xf051},
    {0x83c2,0xf052}, {0x83c3,0xf053}, {0x83c4,0xf054}, {0x83c5,0xf055}, {0x83c6,0xf056}, {0x83c7,0xf057}, {0x83c8,0xf058}, {0x83c9,0xf059}, {0x83ca,0xf05a}, {0x83cb,0xf05b},
    {0x83cc,0xf05c}, {0x83cd,0xf05d}, {0x83ce,0xf05e}, {0x83cf,0xf05f}, {0x83d0,0xf060}, {0x83d1,0xf061}, {0x83d2,0xf062}, {0x83d3,0xf063}, {0x83d4,0xf064}, {0x83d5,0xf065},
    {0x83d6,0xf066}, {0x83d7,0xf067}, {0x83d8,0xf068}, {0x83d9,0xf069}, {0x83da,0xf06a}, {0x83db,0xf06b}, {0x83dc,0xf06c}, {0x83dd,0xf06d}, {0x83de,0xf06e}, {0x83df,0xf06f},
    {0x83e0,0xf070}, {0x83e1,0xf071}, {0x83e2,0xf072}, {0x83e3,0xf073}, {0x83e4,0xf074}, {0x83e5,0xf075}, {0x83e6,0xf076}, {0x83e7,0xf077}, {0x83e8,0xf078}, {0x83e9,0xf079},
    {0x83ea,0xf07a}, {0x83eb,0xf07b}, {0x83ec,0xf07c}, {0x83ed,0xf07d}, {0x83ee,0xf07e}, {0x83ef,0xf07f}, {0x83f0,0xf080}, {0x83f1,0xf081}, {0x83f2,0xf082}, {0x83f3,0xf083},
    {0x83f4,0xf084}, {0x83f5,0xf085}, {0x83f6,0xf086}, {0x83f7,0xf087}, {0x83f8,0xf088}, {0x83f9,0xf089}, {0x83fa,0xf08a}, {0x83fb,0xf08b}, {0x83fc,0xf08c}, {0x83fd,0xf08d},
    {0x83fe,0xf08e}, {0x8440,0xf08f}, {0x8441,0xf090}, {0x8442,0xf091}, {0x8443,0xf092}, {0x8444,0xf093}, {0x8445,0xf094}, {0x8446,0xf095}, {0x8447,0xf096}, {0x8448,0xf097},
    {0x8449,0xf098}, {0x844a,0xf099}, {0x844b,0xf09a}, {0x844c,0xf09b}, {0x844d,0xf09c}, {0x844e,0xf09d}, {0x844f,0xf09e}, {0x8450,0xf09f}, {0x8451,0xf0a0}, {0x8452,0xf0a1},
    {0x8453,0xf0a2}, {0x8454,0xf0a3}, {0x8455,0xf0a4}, {0x8456,0xf0a5}, {0x8457,0xf0a6}, {0x8458,0xf0a7}, {0x8459,0xf0a8}, {0x845a,0xf0a9}, {0x845b,0xf0aa}, {0x845c,0xf0ab},
    {0x845d,0xf0ac}, {0x845e,0xf0ad}, {0x845f,0xf0ae}, {0x8460,0xf0af}, {0x8461,0xf0b0}, {0x8462,0xf0b1}, {0x8463,0xf0b2}, {0x8464,0xf0b3}, {0x8465,0xf0b4}, {0x8466,0xf0b5},
    {0x8467,0xf0b6}, {0x8468,0xf0b7}, {0x8469,0xf0b8}, {0x846a,0xf0b9}, {0x846b,0xf0ba}, {0x846c,0xf0bb}, {0x846d,0xf0bc}, {0x846e,0xf0bd}, {0x846f,0xf0be}, {0x8470,0xf0bf},
    {0x8471,0xf0c0}, {0x8472,0xf0c1}, {0x8473,0xf0c2}, {0x8474,0xf0c3}, {0x8475,0xf0c4}, {0x8476,0xf0c5}, {0x8477,0xf0c6}, {0x8478,0xf0c7}, {0x8479,0xf0c8}, {0x847a,0xf0c9},
    {0x847b,0xf0ca}, {0x847c,0xf0cb}, {0x847d,0xf0cc}, {0x847e,0xf0cd}, {0x84a1,0xf0ce}, {0x84a2,0xf0cf}, {0x84a3,0xf0d0}, {0x84a4,0xf0d1}, {0x84a5,0xf0d2}, {0x84a6,0xf0d3},
    {0x84a7,0xf0d4}, {0x84a8,0xf0d5}, {0x84a9,0xf0d6}, {0x84aa,0xf0d7}, {0x84ab,0xf0d8}, {0x84ac,0xf0d9}, {0x84ad,0xf0da}, {0x84ae,0xf0db}, {0x84af,0xf0dc}, {0x84b0,0xf0dd},
    {0x84b1,0xf0de}, {0x84b2,0xf0df}, {0x84b3,0xf0e0}, {0x84b4,0xf0e1}, {0x84b5,0xf0e2}, {0x84b6,0xf0e3}, {0x84b7,0xf0e4}, {0x84b8,0xf0e5}, {0x84b9,0xf0e6}, {0x84ba,0xf0e7},
    {0x84bb,0xf0e8}, {0x84bc,0xf0e9}, {0x84bd,0xf0ea}, {0x84be,0xf0eb}, {0x84bf,0xf0ec}, {0x84c0,0xf0ed}, {0x84c1,0xf0ee}, {0x84c2,0xf0ef}, {0x84c3,0xf0f0}, {0x84c4,0xf0f1},
    {0x84c5,0xf0f2}, {0x84c6,0xf0f3}, {0x84c7,0xf0f4}, {0x84c8,0xf0f5}, {0x84c9,0xf0f6}, {0x84ca,0xf0f7}, {0x84cb,0xf0f8}, {0x84cc,0xf0f9}, {0x84cd,0xf0fa}, {0x84ce,0xf0fb},
    {0x84cf,0xf0fc}, {0x84d0,0xf0fd}, {0x84d1,0xf0fe}, {0x84d2,0xf0ff}, {0x84d3,0xf100}, {0x84d4,0xf101}, {0x84d5,0xf102}, {0x84d6,0xf103}, {0x84d7,0xf104}, {0x84d8,0xf105},
    {0x84d9,0xf106}, {0x84da,0xf107}, {0x84db,0xf108}, {0x84dc,0xf109}, {0x84dd,0xf10a}, {0x84de,0xf10b}, {0x84df,0xf10c}, {0x84e0,0xf10d}, {0x84e1,0xf10e}, {0x84e2,0xf10f},
    {0x84e3,0xf110}, {0x84e4,0xf111}, {0x84e5,0xf112}, {0x84e6,0xf113}, {0x84e7,0xf114}, {0x84e8,0xf115}, {0x84e9,0xf116}, {0x84ea,0xf117}, {0x84eb,0xf118}, {0x84ec,0xf119},
    {0x84ed,0xf11a}, {0x84ee,0xf11b}, {0x84ef,0xf11c}, {0x84f0,0xf11d}, {0x84f1,0xf11e}, {0x84f2,0xf11f}, {0x84f3,0xf120}, {0x84f4,0xf121}, {0x84f5,0xf122}, {0x84f6,0xf123},
    {0x84f7,0xf124}, {0x84f8,0xf125}, {0x84f9,0xf126}, {0x84fa,0xf127}, {0x84fb,0xf128}, {0x84fc,0xf129}, {0x84fd,0xf12a}, {0x84fe,0xf12b}, {0x8540,0xf12c}, {0x8541,0xf12d},
    {0x8542,0xf12e}, {0x8543,0xf12f}, {0x8544,0xf130}, {0x8545,0xf131}, {0x8546,0xf132}, {0x8547,0xf133}, {0x8548,0xf134}, {0x8549,0xf135}, {0x854a,0xf136}, {0x854b,0xf137},
    {0x854c,0xf138}, {0x854d,0xf139}, {0x854e,0xf13a}, {0x854f,0xf13b}, {0x8550,0xf13c}, {0x8551,0xf13d}, {0x8552,0xf13e}, {0x8553,0xf13f}, {0x8554,0xf140}, {0x8555,0xf141},
    {0x8556,0xf142}, {0x8557,0xf143}, {0x8558,0xf144}, {0x8559,0xf145}, {0x855a,0xf146}, {0x855b,0xf147}, {0x855c,0xf148}, {0x855d,0xf149}, {0x855e,0xf14a}, {0x855f,0xf14b},
    {0x8560,0xf14c}, {0x8561,0xf14d}, {0x8562,0xf14e}, {0x8563,0xf14f}, {0x8564,0xf150}, {0x8565,0xf151}, {0x8566,0xf152}, {0x8567,0xf153}, {0x8568,0xf154}, {0x8569,0xf155},
    {0x856a,0xf156}, {0x856b,0xf157}, {0x856c,0xf158}, {0x856d,0xf159}, {0x856e,0xf15a}, {0x856f,0xf15b}, {0x8570,0xf15c}, {0x8571,0xf15d}, {0x8572,0xf15e}, {0x8573,0xf15f},
    {0x8574,0xf160}, {0x8575,0xf161}, {0x8576,0xf162}, {0x8577,0xf163}, {0x8578,0xf164}, {0x8579,0xf165}, {0x857a,0xf166}, {0x857b,0xf167}, {0x857c,0xf168}, {0x857d,0xf169},
    {0x857e,0xf16a}, {0x85a1,0xf16b}, {0x85a2,0xf16c}, {0x85a3,0xf16d}, {0x85a4,0xf16e}, {0x85a5,0xf16f}, {0x85a6,0xf170}, {0x85a7,0xf171}, {0x85a8,0xf172}, {0x85a9,0xf173},
    {0x85aa,0xf174}, {0x85ab,0xf175}, {0x85ac,0xf176}, {0x85ad,0xf177}, {0x85ae,0xf178}, {0x85af,0xf179}, {0x85b0,0xf17a}, {0x85b1,0xf17b}, {0x85b2,0xf17c}, {0x85b3,0xf17d},
    {0x85b4,0xf17e}, {0x85b5,0xf17f}, {0x85b6,0xf180}, {0x85b7,0xf181}, {0x85b8,0xf182}, {0x85b9,0xf183}, {0x85ba,0xf184}, {0x85bb,0xf185}, {0x85bc,0xf186}, {0x85bd,0xf187},
    {0x85be,0xf188}, {0x85bf,0xf189}, {0x85c0,0xf18a}, {0x85c1,0xf18b}, {0x85c2,0xf18c}, {0x85c3,0xf18d}, {0x85c4,0xf18e}, {0x85c5,0xf18f}, {0x85c6,0xf190}, {0x85c7,0xf191},
    {0x85c8,0xf192}, {0x85c9,0xf193}, {0x85ca,0xf194}, {0x85cb,0xf195}, {0x85cc,0xf196}, {0x85cd,0xf197}, {0x85ce,0xf198}, {0x85cf,0xf199}, {0x85d0,0xf19a}, {0x85d1,0xf19b},
    {0x85d2,0xf19c}, {0x85d3,0xf19d}, {0x85d4,0xf19e}, {0x85d5,0xf19f}, {0x85d6,0xf1a0}, {0x85d7,0xf1a1}, {0x85d8,0xf1a2}, {0x85d9,0xf1a3}, {0x85da,0xf1a4}, {0x85db,0xf1a5},
    {0x85dc,0xf1a6}, {0x85dd,0xf1a7}, {0x85de,0xf1a8}, {0x85df,0xf1a9}, {0x85e0,0xf1aa}, {0x85e1,0xf1ab}, {0x85e2,0xf1ac}, {0x85e3,0xf1ad}, {0x85e4,0xf1ae}, {0x85e5,0xf1af},
    {0x85e6,0xf1b0}, {0x85e7,0xf1b1}, {0x85e8,0xf1b2}, {0x85e9,0xf1b3}, {0x85ea,0xf1b4}, {0x85eb,0xf1b5}, {0x85ec,0xf1b6}, {0x85ed,0xf1b7}, {0x85ee,0xf1b8}, {0x85ef,0xf1b9},
    {0x85f0,0xf1ba}, {0x85f1,0xf1bb}, {0x85f2,0xf1bc}, {0x85f3,0xf1bd}, {0x85f4,0xf1be}, {0x85f5,0xf1bf}, {0x85f6,0xf1c0}, {0x85f7,0xf1c1}, {0x85f8,0xf1c2}, {0x85f9,0xf1c3},
    {0x85fa,0xf1c4}, {0x85fb,0xf1c5}, {0x85fc,0xf1c6}, {0x85fd,0xf1c7}, {0x85fe,0xf1c8}, {0x8640,0xf1c9}, {0x8641,0xf1ca}, {0x8642,0xf1cb}, {0x8643,0xf1cc}, {0x8644,0xf1cd},
    {0x8645,0xf1ce}, {0x8646,0xf1cf}, {0x8647,0xf1d0}, {0x8648,0xf1d1}, {0x8649,0xf1d2}, {0x864a,0xf1d3}, {0x864b,0xf1d4}, {0x864c,0xf1d5}, {0x864d,0xf1d6}, {0x864e,0xf1d7},
    {0x864f,0xf1d8}, {0x8650,0xf1d9}, {0x8651,0xf1da}, {0x8652,0xf1db}, {0x8653,0xf1dc}, {0x8654,0xf1dd}, {0x8655,0xf1de}, {0x8656,0xf1df}, {0x8657,0xf1e0}, {0x8658,0xf1e1},
    {0x8659,0xf1e2}, {0x865a,0xf1e3}, {0x865b,0xf1e4}, {0x865c,0xf1e5}, {0x865d,0xf1e6}, {0x865e,0xf1e7}, {0x865f,0xf1e8}, {0x8660,0xf1e9}, {0x8661,0xf1ea}, {0x8662,0xf1eb},
    {0x8663,0xf1ec}, {0x8664,0xf1ed}, {0x8665,0xf1ee}, {0x8666,0xf1ef}, {0x8667,0xf1f0}, {0x8668,0xf1f1}, {0x8669,0xf1f2}, {0x866a,0xf1f3}, {0x866b,0xf1f4}, {0x866c,0xf1f5},
    {0x866d,0xf1f6}, {0x866e,0xf1f7}, {0x866f,0xf1f8}, {0x8670,0xf1f9}, {0x8671,0xf1fa}, {0x8672,0xf1fb}, {0x8673,0xf1fc}, {0x8674,0xf1fd}, {0x8675,0xf1fe}, {0x8676,0xf1ff},
    {0x8677,0xf200}, {0x8678,0xf201}, {0x8679,0xf202}, {0x867a,0xf203}, {0x867b,0xf204}, {0x867c,0xf205}, {0x867d,0xf206}, {0x867e,0xf207}, {0x86a1,0xf208}, {0x86a2,0xf209},
    {0x86a3,0xf20a}, {0x86a4,0xf20b}, {0x86a5,0xf20c}, {0x86a6,0xf20d}, {0x86a7,0xf20e}, {0x86a8,0xf20f}, {0x86a9,0xf210}, {0x86aa,0xf211}, {0x86ab,0xf212}, {0x86ac,0xf213},
    {0x86ad,0xf214}, {0x86ae,0xf215}, {0x86af,0xf216}, {0x86b0,0xf217}, {0x86b1,0xf218}, {0x86b2,0xf219}, {0x86b3,0xf21a}, {0x86b4,0xf21b}, {0x86b5,0xf21c}, {0x86b6,0xf21d},
    {0x86b7,0xf21e}, {0x86b8,0xf21f}, {0x86b9,0xf220}, {0x86ba,0xf221}, {0x86bb,0xf222}, {0x86bc,0xf223}, {0x86bd,0xf224}, {0x86be,0xf225}, {0x86bf,0xf226}, {0x86c0,0xf227},
    {0x86c1,0xf228}, {0x86c2,0xf229}, {0x86c3,0xf22a}, {0x86c4,0xf22b}, {0x86c5,0xf22c}, {0x86c6,0xf22d}, {0x86c7,0xf22e}, {0x86c8,0xf22f}, {0x86c9,0xf230}, {0x86ca,0xf231},
    {0x86cb,0xf232}, {0x86cc,0xf233}, {0x86cd,0xf234}, {0x86ce,0xf235}, {0x86cf,0xf236}, {0x86d0,0xf237}, {0x86d1,0xf238}, {0x86d2,0xf239}, {0x86d3,0xf23a}, {0x86d4,0xf23b},
    {0x86d5,0xf23c}, {0x86d6,0xf23d}, {0x86d7,0xf23e}, {0x86d8,0xf23f}, {0x86d9,0xf240}, {0x86da,0xf241}, {0x86db,0xf242}, {0x86dc,0xf243}, {0x86dd,0xf244}, {0x86de,0xf245},
    {0x86df,0xf246}, {0x86e0,0xf247}, {0x86e1,0xf248}, {0x86e2,0xf249}, {0x86e3,0xf24a}, {0x86e4,0xf24b}, {0x86e5,0xf24c}, {0x86e6,0xf24d}, {0x86e7,0xf24e}, {0x86e8,0xf24f},
    {0x86e9,0xf250}, {0x86ea,0xf251}, {0x86eb,0xf252}, {0x86ec,0xf253}, {0x86ed,0xf254}, {0x86ee,0xf255}, {0x86ef,0xf256}, {0x86f0,0xf257}, {0x86f1,0xf258}, {0x86f2,0xf259},
    {0x86f3,0xf25a}, {0x86f4,0xf25b}, {0x86f5,0xf25c}, {0x86f6,0xf25d}, {0x86f7,0xf25e}, {0x86f8,0xf25f}, {0x86f9,0xf260}, {0x86fa,0xf261}, {0x86fb,0xf262}, {0x86fc,0xf263},
    {0x86fd,0xf264}, {0x86fe,0xf265}, {0x8740,0xf266}, {0x8741,0xf267}, {0x8742,0xf268}, {0x8743,0xf269}, {0x8744,0xf26a}, {0x8745,0xf26b}, {0x8746,0xf26c}, {0x8747,0xf26d},
    {0x8748,0xf26e}, {0x8749,0xf26f}, {0x874a,0xf270}, {0x874b,0xf271}, {0x874c,0xf272}, {0x874d,0xf273}, {0x874e,0xf274}, {0x874f,0xf275}, {0x8750,0xf276}, {0x8751,0xf277},
    {0x8752,0xf278}, {0x8753,0xf279}, {0x8754,0xf27a}, {0x8755,0xf27b}, {0x8756,0xf27c}, {0x8757,0xf27d}, {0x8758,0xf27e}, {0x8759,0xf27f}, {0x875a,0xf280}, {0x875b,0xf281},
    {0x875c,0xf282}, {0x875d,0xf283}, {0x875e,0xf284}, {0x875f,0xf285}, {0x8760,0xf286}, {0x8761,0xf287}, {0x8762,0xf288}, {0x8763,0xf289}, {0x8764,0xf28a}, {0x8765,0xf28b},
    {0x8766,0xf28c}, {0x8767,0xf28d}, {0x8768,0xf28e}, {0x8769,0xf28f}, {0x876a,0xf290}, {0x876b,0xf291}, {0x876c,0xf292}, {0x876d,0xf293}, {0x876e,0xf294}, {0x876f,0xf295},
    {0x8770,0xf296}, {0x8771,0xf297}, {0x8772,0xf298}, {0x8773,0xf299}, {0x8774,0xf29a}, {0x8775,0xf29b}, {0x8776,0xf29c}, {0x8777,0xf29d}, {0x8778,0xf29e}, {0x8779,0xf29f},
    {0x877a,0xf2a0}, {0x877b,0xf2a1}, {0x877c,0xf2a2}, {0x877d,0xf2a3}, {0x877e,0xf2a4}, {0x87a1,0xf2a5}, {0x87a2,0xf2a6}, {0x87a3,0xf2a7}, {0x87a4,0xf2a8}, {0x87a5,0xf2a9},
    {0x87a6,0xf2aa}, {0x87a7,0xf2ab}, {0x87a8,0xf2ac}, {0x87a9,0xf2ad}, {0x87aa,0xf2ae}, {0x87ab,0xf2af}, {0x87ac,0xf2b0}, {0x87ad,0xf2b1}, {0x87ae,0xf2b2}, {0x87af,0xf2b3},
    {0x87b0,0xf2b4}, {0x87b1,0xf2b5}, {0x87b2,0xf2b6}, {0x87b3,0xf2b7}, {0x87b4,0xf2b8}, {0x87b5,0xf2b9}, {0x87b6,0xf2ba}, {0x87b7,0xf2bb}, {0x87b8,0xf2bc}, {0x87b9,0xf2bd},
    {0x87ba,0xf2be}, {0x87bb,0xf2bf}, {0x87bc,0xf2c0}, {0x87bd,0xf2c1}, {0x87be,0xf2c2}, {0x87bf,0xf2c3}, {0x87c0,0xf2c4}, {0x87c1,0xf2c5}, {0x87c2,0xf2c6}, {0x87c3,0xf2c7},
    {0x87c4,0xf2c8}, {0x87c5,0xf2c9}, {0x87c6,0xf2ca}, {0x87c7,0xf2cb}, {0x87c8,0xf2cc}, {0x87c9,0xf2cd}, {0x87ca,0xf2ce}, {0x87cb,0xf2cf}, {0x87cc,0xf2d0}, {0x87cd,0xf2d1},
    {0x87ce,0xf2d2}, {0x87cf,0xf2d3}, {0x87d0,0xf2d4}, {0x87d1,0xf2d5}, {0x87d2,0xf2d6}, {0x87d3,0xf2d7}, {0x87d4,0xf2d8}, {0x87d5,0xf2d9}, {0x87d6,0xf2da}, {0x87d7,0xf2db},
    {0x87d8,0xf2dc}, {0x87d9,0xf2dd}, {0x87da,0xf2de}, {0x87db,0xf2df}, {0x87dc,0xf2e0}, {0x87dd,0xf2e1}, {0x87de,0xf2e2}, {0x87df,0xf2e3}, {0x87e0,0xf2e4}, {0x87e1,0xf2e5},
    {0x87e2,0xf2e6}, {0x87e3,0xf2e7}, {0x87e4,0xf2e8}, {0x87e5,0xf2e9}, {0x87e6,0xf2ea}, {0x87e7,0xf2eb}, {0x87e8,0xf2ec}, {0x87e9,0xf2ed}, {0x87ea,0xf2ee}, {0x87eb,0xf2ef},
    {0x87ec,0xf2f0}, {0x87ed,0xf2f1}, {0x87ee,0xf2f2}, {0x87ef,0xf2f3}, {0x87f0,0xf2f4}, {0x87f1,0xf2f5}, {0x87f2,0xf2f6}, {0x87f3,0xf2f7}, {0x87f4,0xf2f8}, {0x87f5,0xf2f9},
    {0x87f6,0xf2fa}, {0x87f7,0xf2fb}, {0x87f8,0xf2fc}, {0x87f9,0xf2fd}, {0x87fa,0xf2fe}, {0x87fb,0xf2ff}, {0x87fc,0xf300}, {0x87fd,0xf301}, {0x87fe,0xf302}, {0x8840,0xf303},
    {0x8841,0xf304}, {0x8842,0xf305}, {0x8843,0xf306}, {0x8844,0xf307}, {0x8845,0xf308}, {0x8846,0xf309}, {0x8847,0xf30a}, {0x8848,0xf30b}, {0x8849,0xf30c}, {0x884a,0xf30d},
    {0x884b,0xf30e}, {0x884c,0xf30f}, {0x884d,0xf310}, {0x884e,0xf311}, {0x884f,0xf312}, {0x8850,0xf313}, {0x8851,0xf314}, {0x8852,0xf315}, {0x8853,0xf316}, {0x8854,0xf317},
    {0x8855,0xf318}, {0x8856,0xf319}, {0x8857,0xf31a}, {0x8858,0xf31b}, {0x8859,0xf31c}, {0x885a,0xf31d}, {0x885b,0xf31e}, {0x885c,0xf31f}, {0x885d,0xf320}, {0x885e,0xf321},
    {0x885f,0xf322}, {0x8860,0xf323}, {0x8861,0xf324}, {0x8862,0xf325}, {0x8863,0xf326}, {0x8864,0xf327}, {0x8865,0xf328}, {0x8866,0xf329}, {0x8867,0xf32a}, {0x8868,0xf32b},
    {0x8869,0xf32c}, {0x886a,0xf32d}, {0x886b,0xf32e}, {0x886c,0xf32f}, {0x886d,0xf330}, {0x886e,0xf331}, {0x886f,0xf332}, {0x8870,0xf333}, {0x8871,0xf334}, {0x8872,0xf335},
    {0x8873,0xf336}, {0x8874,0xf337}, {0x8875,0xf338}, {0x8876,0xf339}, {0x8877,0xf33a}, {0x8878,0xf33b}, {0x8879,0xf33c}, {0x887a,0xf33d}, {0x887b,0xf33e}, {0x887c,0xf33f},
    {0x887d,0xf340}, {0x887e,0xf341}, {0x88a1,0xf342}, {0x88a2,0xf343}, {0x88a3,0xf344}, {0x88a4,0xf345}, {0x88a5,0xf346}, {0x88a6,0xf347}, {0x88a7,0xf348}, {0x88a8,0xf349},
    {0x88a9,0xf34a}, {0x88aa,0xf34b}, {0x88ab,0xf34c}, {0x88ac,0xf34d}, {0x88ad,0xf34e}, {0x88ae,0xf34f}, {0x88af,0xf350}, {0x88b0,0xf351}, {0x88b1,0xf352}, {0x88b2,0xf353},
    {0x88b3,0xf354}, {0x88b4,0xf355}, {0x88b5,0xf356}, {0x88b6,0xf357}, {0x88b7,0xf358}, {0x88b8,0xf359}, {0x88b9,0xf35a}, {0x88ba,0xf35b}, {0x88bb,0xf35c}, {0x88bc,0xf35d},
    {0x88bd,0xf35e}, {0x88be,0xf35f}, {0x88bf,0xf360}, {0x88c0,0xf361}, {0x88c1,0xf362}, {0x88c2,0xf363}, {0x88c3,0xf364}, {0x88c4,0xf365}, {0x88c5,0xf366}, {0x88c6,0xf367},
    {0x88c7,0xf368}, {0x88c8,0xf369}, {0x88c9,0xf36a}, {0x88ca,0xf36b}, {0x88cb,0xf36c}, {0x88cc,0xf36d}, {0x88cd,0xf36e}, {0x88ce,0xf36f}, {0x88cf,0xf370}, {0x88d0,0xf371},
    {0x88d1,0xf372}, {0x88d2,0xf373}, {0x88d3,0xf374}, {0x88d4,0xf375}, {0x88d5,0xf376}, {0x88d6,0xf377}, {0x88d7,0xf378}, {0x88d8,0xf379}, {0x88d9,0xf37a}, {0x88da,0xf37b},
    {0x88db,0xf37c}, {0x88dc,0xf37d}, {0x88dd,0xf37e}, {0x88de,0xf37f}, {0x88df,0xf380}, {0x88e0,0xf381}, {0x88e1,0xf382}, {0x88e2,0xf383}, {0x88e3,0xf384}, {0x88e4,0xf385},
    {0x88e5,0xf386}, {0x88e6,0xf387}, {0x88e7,0xf388}, {0x88e8,0xf389}, {0x88e9,0xf38a}, {0x88ea,0xf38b}, {0x88eb,0xf38c}, {0x88ec,0xf38d}, {0x88ed,0xf38e}, {0x88ee,0xf38f},
    {0x88ef,0xf390}, {0x88f0,0xf391}, {0x88f1,0xf392}, {0x88f2,0xf393}, {0x88f3,0xf394}, {0x88f4,0xf395}, {0x88f5,0xf396}, {0x88f6,0xf397}, {0x88f7,0xf398}, {0x88f8,0xf399},
    {0x88f9,0xf39a}, {0x88fa,0xf39b}, {0x88fb,0xf39c}, {0x88fc,0xf39d}, {0x88fd,0xf39e}, {0x88fe,0xf39f}, {0x8940,0xf3a0}, {0x8941,0xf3a1}, {0x8942,0xf3a2}, {0x8943,0xf3a3},
    {0x8944,0xf3a4}, {0x8945,0xf3a5}, {0x8946,0xf3a6}, {0x8947,0xf3a7}, {0x8948,0xf3a8}, {0x8949,0xf3a9}, {0x894a,0xf3aa}, {0x894b,0xf3ab}, {0x894c,0xf3ac}, {0x894d,0xf3ad},
    {0x894e,0xf3ae}, {0x894f,0xf3af}, {0x8950,0xf3b0}, {0x8951,0xf3b1}, {0x8952,0xf3b2}, {0x8953,0xf3b3}, {0x8954,0xf3b4}, {0x8955,0xf3b5}, {0x8956,0xf3b6}, {0x8957,0xf3b7},
    {0x8958,0xf3b8}, {0x8959,0xf3b9}, {0x895a,0xf3ba}, {0x895b,0xf3bb}, {0x895c,0xf3bc}, {0x895d,0xf3bd}, {0x895e,0xf3be}, {0x895f,0xf3bf}, {0x8960,0xf3c0}, {0x8961,0xf3c1},
    {0x8962,0xf3c2}, {0x8963,0xf3c3}, {0x8964,0xf3c4}, {0x8965,0xf3c5}, {0x8966,0xf3c6}, {0x8967,0xf3c7}, {0x8968,0xf3c8}, {0x8969,0xf3c9}, {0x896a,0xf3ca}, {0x896b,0xf3cb},
    {0x896c,0xf3cc}, {0x896d,0xf3cd}, {0x896e,0xf3ce}, {0x896f,0xf3cf}, {0x8970,0xf3d0}, {0x8971,0xf3d1}, {0x8972,0xf3d2}, {0x8973,0xf3d3}, {0x8974,0xf3d4}, {0x8975,0xf3d5},
    {0x8976,0xf3d6}, {0x8977,0xf3d7}, {0x8978,0xf3d8}, {0x8979,0xf3d9}, {0x897a,0xf3da}, {0x897b,0xf3db}, {0x897c,0xf3dc}, {0x897d,0xf3dd}, {0x897e,0xf3de}, {0x89a1,0xf3df},
    {0x89a2,0xf3e0}, {0x89a3,0xf3e1}, {0x89a4,0xf3e2}, {0x89a5,0xf3e3}, {0x89a6,0xf3e4}, {0x89a7,0xf3e5}, {0x89a8,0xf3e6}, {0x89a9,0xf3e7}, {0x89aa,0xf3e8}, {0x89ab,0xf3e9},
    {0x89ac,0xf3ea}, {0x89ad,0xf3eb}, {0x89ae,0xf3ec}, {0x89af,0xf3ed}, {0x89b0,0xf3ee}, {0x89b1,0xf3ef}, {0x89b2,0xf3f0}, {0x89b3,0xf3f1}, {0x89b4,0xf3f2}, {0x89b5,0xf3f3},
    {0x89b6,0xf3f4}, {0x89b7,0xf3f5}, {0x89b8,0xf3f6}, {0x89b9,0xf3f7}, {0x89ba,0xf3f8}, {0x89bb,0xf3f9}, {0x89bc,0xf3fa}, {0x89bd,0xf3fb}, {0x89be,0xf3fc}, {0x89bf,0xf3fd},
    {0x89c0,0xf3fe}, {0x89c1,0xf3ff}, {0x89c2,0xf400}, {0x89c3,0xf401}, {0x89c4,0xf402}, {0x89c5,0xf403}, {0x89c6,0xf404}, {0x89c7,0xf405}, {0x89c8,0xf406}, {0x89c9,0xf407},
    {0x89ca,0xf408}, {0x89cb,0xf409}, {0x89cc,0xf40a}, {0x89cd,0xf40b}, {0x89ce,0xf40c}, {0x89cf,0xf40d}, {0x89d0,0xf40e}, {0x89d1,0xf40f}, {0x89d2,0xf410}, {0x89d3,0xf411},
    {0x89d4,0xf412}, {0x89d5,0xf413}, {0x89d6,0xf414}, {0x89d7,0xf415}, {0x89d8,0xf416}, {0x89d9,0xf417}, {0x89da,0xf418}, {0x89db,0xf419}, {0x89dc,0xf41a}, {0x89dd,0xf41b},
    {0x89de,0xf41c}, {0x89df,0xf41d}, {0x89e0,0xf41e}, {0x89e1,0xf41f}, {0x89e2,0xf420}, {0x89e3,0xf421}, {0x89e4,0xf422}, {0x89e5,0xf423}, {0x89e6,0xf424}, {0x89e7,0xf425},
    {0x89e8,0xf426}, {0x89e9,0xf427}, {0x89ea,0xf428}, {0x89eb,0xf429}, {0x89ec,0xf42a}, {0x89ed,0xf42b}, {0x89ee,0xf42c}, {0x89ef,0xf42d}, {0x89f0,0xf42e}, {0x89f1,0xf42f},
    {0x89f2,0xf430}, {0x89f3,0xf431}, {0x89f4,0xf432}, {0x89f5,0xf433}, {0x89f6,0xf434}, {0x89f7,0xf435}, {0x89f8,0xf436}, {0x89f9,0xf437}, {0x89fa,0xf438}, {0x89fb,0xf439},
    {0x89fc,0xf43a}, {0x89fd,0xf43b}, {0x89fe,0xf43c}, {0x8a40,0xf43d}, {0x8a41,0xf43e}, {0x8a42,0xf43f}, {0x8a43,0xf440}, {0x8a44,0xf441}, {0x8a45,0xf442}, {0x8a46,0xf443},
    {0x8a47,0xf444}, {0x8a48,0xf445}, {0x8a49,0xf446}, {0x8a4a,0xf447}, {0x8a4b,0xf448}, {0x8a4c,0xf449}, {0x8a4d,0xf44a}, {0x8a4e,0xf44b}, {0x8a4f,0xf44c}, {0x8a50,0xf44d},
    {0x8a51,0xf44e}, {0x8a52,0xf44f}, {0x8a53,0xf450}, {0x8a54,0xf451}, {0x8a55,0xf452}, {0x8a56,0xf453}, {0x8a57,0xf454}, {0x8a58,0xf455}, {0x8a59,0xf456}, {0x8a5a,0xf457},
    {0x8a5b,0xf458}, {0x8a5c,0xf459}, {0x8a5d,0xf45a}, {0x8a5e,0xf45b}, {0x8a5f,0xf45c}, {0x8a60,0xf45d}, {0x8a61,0xf45e}, {0x8a62,0xf45f}, {0x8a63,0xf460}, {0x8a64,0xf461},
    {0x8a65,0xf462}, {0x8a66,0xf463}, {0x8a67,0xf464}, {0x8a68,0xf465}, {0x8a69,0xf466}, {0x8a6a,0xf467}, {0x8a6b,0xf468}, {0x8a6c,0xf469}, {0x8a6d,0xf46a}, {0x8a6e,0xf46b},
    {0x8a6f,0xf46c}, {0x8a70,0xf46d}, {0x8a71,0xf46e}, {0x8a72,0xf46f}, {0x8a73,0xf470}, {0x8a74,0xf471}, {0x8a75,0xf472}, {0x8a76,0xf473}, {0x8a77,0xf474}, {0x8a78,0xf475},
    {0x8a79,0xf476}, {0x8a7a,0xf477}, {0x8a7b,0xf478}, {0x8a7c,0xf479}, {0x8a7d,0xf47a}, {0x8a7e,0xf47b}, {0x8aa1,0xf47c}, {0x8aa2,0xf47d}, {0x8aa3,0xf47e}, {0x8aa4,0xf47f},
    {0x8aa5,0xf480}, {0x8aa6,0xf481}, {0x8aa7,0xf482}, {0x8aa8,0xf483}, {0x8aa9,0xf484}, {0x8aaa,0xf485}, {0x8aab,0xf486}, {0x8aac,0xf487}, {0x8aad,0xf488}, {0x8aae,0xf489},
    {0x8aaf,0xf48a}, {0x8ab0,0xf48b}, {0x8ab1,0xf48c}, {0x8ab2,0xf48d}, {0x8ab3,0xf48e}, {0x8ab4,0xf48f}, {0x8ab5,0xf490}, {0x8ab6,0xf491}, {0x8ab7,0xf492}, {0x8ab8,0xf493},
    {0x8ab9,0xf494}, {0x8aba,0xf495}, {0x8abb,0xf496}, {0x8abc,0xf497}, {0x8abd,0xf498}, {0x8abe,0xf499}, {0x8abf,0xf49a}, {0x8ac0,0xf49b}, {0x8ac1,0xf49c}, {0x8ac2,0xf49d},
    {0x8ac3,0xf49e}, {0x8ac4,0xf49f}, {0x8ac5,0xf4a0}, {0x8ac6,0xf4a1}, {0x8ac7,0xf4a2}, {0x8ac8,0xf4a3}, {0x8ac9,0xf4a4}, {0x8aca,0xf4a5}, {0x8acb,0xf4a6}, {0x8acc,0xf4a7},
    {0x8acd,0xf4a8}, {0x8ace,0xf4a9}, {0x8acf,0xf4aa}, {0x8ad0,0xf4ab}, {0x8ad1,0xf4ac}, {0x8ad2,0xf4ad}, {0x8ad3,0xf4ae}, {0x8ad4,0xf4af}, {0x8ad5,0xf4b0}, {0x8ad6,0xf4b1},
    {0x8ad7,0xf4b2}, {0x8ad8,0xf4b3}, {0x8ad9,0xf4b4}, {0x8ada,0xf4b5}, {0x8adb,0xf4b6}, {0x8adc,0xf4b7}, {0x8add,0xf4b8}, {0x8ade,0xf4b9}, {0x8adf,0xf4ba}, {0x8ae0,0xf4bb},
    {0x8ae1,0xf4bc}, {0x8ae2,0xf4bd}, {0x8ae3,0xf4be}, {0x8ae4,0xf4bf}, {0x8ae5,0xf4c0}, {0x8ae6,0xf4c1}, {0x8ae7,0xf4c2}, {0x8ae8,0xf4c3}, {0x8ae9,0xf4c4}, {0x8aea,0xf4c5},
    {0x8aeb,0xf4c6}, {0x8aec,0xf4c7}, {0x8aed,0xf4c8}, {0x8aee,0xf4c9}, {0x8aef,0xf4ca}, {0x8af0,0xf4cb}, {0x8af1,0xf4cc}, {0x8af2,0xf4cd}, {0x8af3,0xf4ce}, {0x8af4,0xf4cf},
    {0x8af5,0xf4d0}, {0x8af6,0xf4d1}, {0x8af7,0xf4d2}, {0x8af8,0xf4d3}, {0x8af9,0xf4d4}, {0x8afa,0xf4d5}, {0x8afb,0xf4d6}, {0x8afc,0xf4d7}, {0x8afd,0xf4d8}, {0x8afe,0xf4d9},
    {0x8b40,0xf4da}, {0x8b41,0xf4db}, {0x8b42,0xf4dc}, {0x8b43,0xf4dd}, {0x8b44,0xf4de}, {0x8b45,0xf4df}, {0x8b46,0xf4e0}, {0x8b47,0xf4e1}, {0x8b48,0xf4e2}, {0x8b49,0xf4e3},
    {0x8b4a,0xf4e4}, {0x8b4b,0xf4e5}, {0x8b4c,0xf4e6}, {0x8b4d,0xf4e7}, {0x8b4e,0xf4e8}, {0x8b4f,0xf4e9}, {0x8b50,0xf4ea}, {0x8b51,0xf4eb}, {0x8b52,0xf4ec}, {0x8b53,0xf4ed},
    {0x8b54,0xf4ee}, {0x8b55,0xf4ef}, {0x8b56,0xf4f0}, {0x8b57,0xf4f1}, {0x8b58,0xf4f2}, {0x8b59,0xf4f3}, {0x8b5a,0xf4f4}, {0x8b5b,0xf4f5}, {0x8b5c,0xf4f6}, {0x8b5d,0xf4f7},
    {0x8b5e,0xf4f8}, {0x8b5f,0xf4f9}, {0x8b60,0xf4fa}, {0x8b61,0xf4fb}, {0x8b62,0xf4fc}, {0x8b63,0xf4fd}, {0x8b64,0xf4fe}, {0x8b65,0xf4ff}, {0x8b66,0xf500}, {0x8b67,0xf501},
    {0x8b68,0xf502}, {0x8b69,0xf503}, {0x8b6a,0xf504}, {0x8b6b,0xf505}, {0x8b6c,0xf506}, {0x8b6d,0xf507}, {0x8b6e,0xf508}, {0x8b6f,0xf509}, {0x8b70,0xf50a}, {0x8b71,0xf50b},
    {0x8b72,0xf50c}, {0x8b73,0xf50d}, {0x8b74,0xf50e}, {0x8b75,0xf50f}, {0x8b76,0xf510}, {0x8b77,0xf511}, {0x8b78,0xf512}, {0x8b79,0xf513}, {0x8b7a,0xf514}, {0x8b7b,0xf515},
    {0x8b7c,0xf516}, {0x8b7d,0xf517}, {0x8b7e,0xf518}, {0x8ba1,0xf519}, {0x8ba2,0xf51a}, {0x8ba3,0xf51b}, {0x8ba4,0xf51c}, {0x8ba5,0xf51d}, {0x8ba6,0xf51e}, {0x8ba7,0xf51f},
    {0x8ba8,0xf520}, {0x8ba9,0xf521}, {0x8baa,0xf522}, {0x8bab,0xf523}, {0x8bac,0xf524}, {0x8bad,0xf525}, {0x8bae,0xf526}, {0x8baf,0xf527}, {0x8bb0,0xf528}, {0x8bb1,0xf529},
    {0x8bb2,0xf52a}, {0x8bb3,0xf52b}, {0x8bb4,0xf52c}, {0x8bb5,0xf52d}, {0x8bb6,0xf52e}, {0x8bb7,0xf52f}, {0x8bb8,0xf530}, {0x8bb9,0xf531}, {0x8bba,0xf532}, {0x8bbb,0xf533},
    {0x8bbc,0xf534}, {0x8bbd,0xf535}, {0x8bbe,0xf536}, {0x8bbf,0xf537}, {0x8bc0,0xf538}, {0x8bc1,0xf539}, {0x8bc2,0xf53a}, {0x8bc3,0xf53b}, {0x8bc4,0xf53c}, {0x8bc5,0xf53d},
    {0x8bc6,0xf53e}, {0x8bc7,0xf53f}, {0x8bc8,0xf540}, {0x8bc9,0xf541}, {0x8bca,0xf542}, {0x8bcb,0xf543}, {0x8bcc,0xf544}, {0x8bcd,0xf545}, {0x8bce,0xf546}, {0x8bcf,0xf547},
    {0x8bd0,0xf548}, {0x8bd1,0xf549}, {0x8bd2,0xf54a}, {0x8bd3,0xf54b}, {0x8bd4,0xf54c}, {0x8bd5,0xf54d}, {0x8bd6,0xf54e}, {0x8bd7,0xf54f}, {0x8bd8,0xf550}, {0x8bd9,0xf551},
    {0x8bda,0xf552}, {0x8bdb,0xf553}, {0x8bdc,0xf554}, {0x8bdd,0xf555}, {0x8bde,0xf556}, {0x8bdf,0xf557}, {0x8be0,0xf558}, {0x8be1,0xf559}, {0x8be2,0xf55a}, {0x8be3,0xf55b},
    {0x8be4,0xf55c}, {0x8be5,0xf55d}, {0x8be6,0xf55e}, {0x8be7,0xf55f}, {0x8be8,0xf560}, {0x8be9,0xf561}, {0x8bea,0xf562}, {0x8beb,0xf563}, {0x8bec,0xf564}, {0x8bed,0xf565},
    {0x8bee,0xf566}, {0x8bef,0xf567}, {0x8bf0,0xf568}, {0x8bf1,0xf569}, {0x8bf2,0xf56a}, {0x8bf3,0xf56b}, {0x8bf4,0xf56c}, {0x8bf5,0xf56d}, {0x8bf6,0xf56e}, {0x8bf7,0xf56f},
    {0x8bf8,0xf570}, {0x8bf9,0xf571}, {0x8bfa,0xf572}, {0x8bfb,0xf573}, {0x8bfc,0xf574}, {0x8bfd,0xf575}, {0x8bfe,0xf576}, {0x8c40,0xf577}, {0x8c41,0xf578}, {0x8c42,0xf579},
    {0x8c43,0xf57a}, {0x8c44,0xf57b}, {0x8c45,0xf57c}, {0x8c46,0xf57d}, {0x8c47,0xf57e}, {0x8c48,0xf57f}, {0x8c49,0xf580}, {0x8c4a,0xf581}, {0x8c4b,0xf582}, {0x8c4c,0xf583},
    {0x8c4d,0xf584}, {0x8c4e,0xf585}, {0x8c4f,0xf586}, {0x8c50,0xf587}, {0x8c51,0xf588}, {0x8c52,0xf589}, {0x8c53,0xf58a}, {0x8c54,0xf58b}, {0x8c55,0xf58c}, {0x8c56,0xf58d},
    {0x8c57,0xf58e}, {0x8c58,0xf58f}, {0x8c59,0xf590}, {0x8c5a,0xf591}, {0x8c5b,0xf592}, {0x8c5c,0xf593}, {0x8c5d,0xf594}, {0x8c5e,0xf595}, {0x8c5f,0xf596}, {0x8c60,0xf597},
    {0x8c61,0xf598}, {0x8c62,0xf599}, {0x8c63,0xf59a}, {0x8c64,0xf59b}, {0x8c65,0xf59c}, {0x8c66,0xf59d}, {0x8c67,0xf59e}, {0x8c68,0xf59f}, {0x8c69,0xf5a0}, {0x8c6a,0xf5a1},
    {0x8c6b,0xf5a2}, {0x8c6c,0xf5a3}, {0x8c6d,0xf5a4}, {0x8c6e,0xf5a5}, {0x8c6f,0xf5a6}, {0x8c70,0xf5a7}, {0x8c71,0xf5a8}, {0x8c72,0xf5a9}, {0x8c73,0xf5aa}, {0x8c74,0xf5ab},
    {0x8c75,0xf5ac}, {0x8c76,0xf5ad}, {0x8c77,0xf5ae}, {0x8c78,0xf5af}, {0x8c79,0xf5b0}, {0x8c7a,0xf5b1}, {0x8c7b,0xf5b2}, {0x8c7c,0xf5b3}, {0x8c7d,0xf5b4}, {0x8c7e,0xf5b5},
    {0x8ca1,0xf5b6}, {0x8ca2,0xf5b7}, {0x8ca3,0xf5b8}, {0x8ca4,0xf5b9}, {0x8ca5,0xf5ba}, {0x8ca6,0xf5bb}, {0x8ca7,0xf5bc}, {0x8ca8,0xf5bd}, {0x8ca9,0xf5be}, {0x8caa,0xf5bf},
    {0x8cab,0xf5c0}, {0x8cac,0xf5c1}, {0x8cad,0xf5c2}, {0x8cae,0xf5c3}, {0x8caf,0xf5c4}, {0x8cb0,0xf5c5}, {0x8cb1,0xf5c6}, {0x8cb2,0xf5c7}, {0x8cb3,0xf5c8}, {0x8cb4,0xf5c9},
    {0x8cb5,0xf5ca}, {0x8cb6,0xf5cb}, {0x8cb7,0xf5cc}, {0x8cb8,0xf5cd}, {0x8cb9,0xf5ce}, {0x8cba,0xf5cf}, {0x8cbb,0xf5d0}, {0x8cbc,0xf5d1}, {0x8cbd,0xf5d2}, {0x8cbe,0xf5d3},
    {0x8cbf,0xf5d4}, {0x8cc0,0xf5d5}, {0x8cc1,0xf5d6}, {0x8cc2,0xf5d7}, {0x8cc3,0xf5d8}, {0x8cc4,0xf5d9}, {0x8cc5,0xf5da}, {0x8cc6,0xf5db}, {0x8cc7,0xf5dc}, {0x8cc8,0xf5dd},
    {0x8cc9,0xf5de}, {0x8cca,0xf5df}, {0x8ccb,0xf5e0}, {0x8ccc,0xf5e1}, {0x8ccd,0xf5e2}, {0x8cce,0xf5e3}, {0x8ccf,0xf5e4}, {0x8cd0,0xf5e5}, {0x8cd1,0xf5e6}, {0x8cd2,0xf5e7},
    {0x8cd3,0xf5e8}, {0x8cd4,0xf5e9}, {0x8cd5,0xf5ea}, {0x8cd6,0xf5eb}, {0x8cd7,0xf5ec}, {0x8cd8,0xf5ed}, {0x8cd9,0xf5ee}, {0x8cda,0xf5ef}, {0x8cdb,0xf5f0}, {0x8cdc,0xf5f1},
    {0x8cdd,0xf5f2}, {0x8cde,0xf5f3}, {0x8cdf,0xf5f4}, {0x8ce0,0xf5f5}, {0x8ce1,0xf5f6}, {0x8ce2,0xf5f7}, {0x8ce3,0xf5f8}, {0x8ce4,0xf5f9}, {0x8ce5,0xf5fa}, {0x8ce6,0xf5fb},
    {0x8ce7,0xf5fc}, {0x8ce8,0xf5fd}, {0x8ce9,0xf5fe}, {0x8cea,0xf5ff}, {0x8ceb,0xf600}, {0x8cec,0xf601}, {0x8ced,0xf602}, {0x8cee,0xf603}, {0x8cef,0xf604}, {0x8cf0,0xf605},
    {0x8cf1,0xf606}, {0x8cf2,0xf607}, {0x8cf3,0xf608}, {0x8cf4,0xf609}, {0x8cf5,0xf60a}, {0x8cf6,0xf60b}, {0x8cf7,0xf60c}, {0x8cf8,0xf60d}, {0x8cf9,0xf60e}, {0x8cfa,0xf60f},
    {0x8cfb,0xf610}, {0x8cfc,0xf611}, {0x8cfd,0xf612}, {0x8cfe,0xf613}, {0x8d40,0xf614}, {0x8d41,0xf615}, {0x8d42,0xf616}, {0x8d43,0xf617}, {0x8d44,0xf618}, {0x8d45,0xf619},
    {0x8d46,0xf61a}, {0x8d47,0xf61b}, {0x8d48,0xf61c}, {0x8d49,0xf61d}, {0x8d4a,0xf61e}, {0x8d4b,0xf61f}, {0x8d4c,0xf620}, {0x8d4d,0xf621}, {0x8d4e,0xf622}, {0x8d4f,0xf623},
    {0x8d50,0xf624}, {0x8d51,0xf625}, {0x8d52,0xf626}, {0x8d53,0xf627}, {0x8d54,0xf628}, {0x8d55,0xf629}, {0x8d56,0xf62a}, {0x8d57,0xf62b}, {0x8d58,0xf62c}, {0x8d59,0xf62d},
    {0x8d5a,0xf62e}, {0x8d5b,0xf62f}, {0x8d5c,0xf630}, {0x8d5d,0xf631}, {0x8d5e,0xf632}, {0x8d5f,0xf633}, {0x8d60,0xf634}, {0x8d61,0xf635}, {0x8d62,0xf636}, {0x8d63,0xf637},
    {0x8d64,0xf638}, {0x8d65,0xf639}, {0x8d66,0xf63a}, {0x8d67,0xf63b}, {0x8d68,0xf63c}, {0x8d69,0xf63d}, {0x8d6a,0xf63e}, {0x8d6b,0xf63f}, {0x8d6c,0xf640}, {0x8d6d,0xf641},
    {0x8d6e,0xf642}, {0x8d6f,0xf643}, {0x8d70,0xf644}, {0x8d71,0xf645}, {0x8d72,0xf646}, {0x8d73,0xf647}, {0x8d74,0xf648}, {0x8d75,0xf649}, {0x8d76,0xf64a}, {0x8d77,0xf64b},
    {0x8d78,0xf64c}, {0x8d79,0xf64d}, {0x8d7a,0xf64e}, {0x8d7b,0xf64f}, {0x8d7c,0xf650}, {0x8d7d,0xf651}, {0x8d7e,0xf652}, {0x8da1,0xf653}, {0x8da2,0xf654}, {0x8da3,0xf655},
    {0x8da4,0xf656}, {0x8da5,0xf657}, {0x8da6,0xf658}, {0x8da7,0xf659}, {0x8da8,0xf65a}, {0x8da9,0xf65b}, {0x8daa,0xf65c}, {0x8dab,0xf65d}, {0x8dac,0xf65e}, {0x8dad,0xf65f},
    {0x8dae,0xf660}, {0x8daf,0xf661}, {0x8db0,0xf662}, {0x8db1,0xf663}, {0x8db2,0xf664}, {0x8db3,0xf665}, {0x8db4,0xf666}, {0x8db5,0xf667}, {0x8db6,0xf668}, {0x8db7,0xf669},
    {0x8db8,0xf66a}, {0x8db9,0xf66b}, {0x8dba,0xf66c}, {0x8dbb,0xf66d}, {0x8dbc,0xf66e}, {0x8dbd,0xf66f}, {0x8dbe,0xf670}, {0x8dbf,0xf671}, {0x8dc0,0xf672}, {0x8dc1,0xf673},
    {0x8dc2,0xf674}, {0x8dc3,0xf675}, {0x8dc4,0xf676}, {0x8dc5,0xf677}, {0x8dc6,0xf678}, {0x8dc7,0xf679}, {0x8dc8,0xf67a}, {0x8dc9,0xf67b}, {0x8dca,0xf67c}, {0x8dcb,0xf67d},
    {0x8dcc,0xf67e}, {0x8dcd,0xf67f}, {0x8dce,0xf680}, {0x8dcf,0xf681}, {0x8dd0,0xf682}, {0x8dd1,0xf683}, {0x8dd2,0xf684}, {0x8dd3,0xf685}, {0x8dd4,0xf686}, {0x8dd5,0xf687},
    {0x8dd6,0xf688}, {0x8dd7,0xf689}, {0x8dd8,0xf68a}, {0x8dd9,0xf68b}, {0x8dda,0xf68c}, {0x8ddb,0xf68d}, {0x8ddc,0xf68e}, {0x8ddd,0xf68f}, {0x8dde,0xf690}, {0x8ddf,0xf691},
    {0x8de0,0xf692}, {0x8de1,0xf693}, {0x8de2,0xf694}, {0x8de3,0xf695}, {0x8de4,0xf696}, {0x8de5,0xf697}, {0x8de6,0xf698}, {0x8de7,0xf699}, {0x8de8,0xf69a}, {0x8de9,0xf69b},
    {0x8dea,0xf69c}, {0x8deb,0xf69d}, {0x8dec,0xf69e}, {0x8ded,0xf69f}, {0x8dee,0xf6a0}, {0x8def,0xf6a1}, {0x8df0,0xf6a2}, {0x8df1,0xf6a3}, {0x8df2,0xf6a4}, {0x8df3,0xf6a5},
    {0x8df4,0xf6a6}, {0x8df5,0xf6a7}, {0x8df6,0xf6a8}, {0x8df7,0xf6a9}, {0x8df8,0xf6aa}, {0x8df9,0xf6ab}, {0x8dfa,0xf6ac}, {0x8dfb,0xf6ad}, {0x8dfc,0xf6ae}, {0x8dfd,0xf6af},
    {0x8dfe,0xf6b0},
};

static const B5Map b5_8E40_to_uc_map[2983] = {
    {0x8e40,0xe311}, {0x8e41,0xe312}, {0x8e42,0xe313}, {0x8e43,0xe314}, {0x8e44,0xe315}, {0x8e45,0xe316}, {0x8e46,0xe317}, {0x8e47,0xe318}, {0x8e48,0xe319}, {0x8e49,0xe31a},
    {0x8e4a,0xe31b}, {0x8e4b,0xe31c}, {0x8e4c,0xe31d}, {0x8e4d,0xe31e}, {0x8e4e,0xe31f}, {0x8e4f,0xe320}, {0x8e50,0xe321}, {0x8e51,0xe322}, {0x8e52,0xe323}, {0x8e53,0xe324},
    {0x8e54,0xe325}, {0x8e55,0xe326}, {0x8e56,0xe327}, {0x8e57,0xe328}, {0x8e58,0xe329}, {0x8e59,0xe32a}, {0x8e5a,0xe32b}, {0x8e5b,0xe32c}, {0x8e5c,0xe32d}, {0x8e5d,0xe32e},
    {0x8e5e,0xe32f}, {0x8e5f,0xe330}, {0x8e60,0xe331}, {0x8e61,0xe332}, {0x8e62,0xe333}, {0x8e63,0xe334}, {0x8e64,0xe335}, {0x8e65,0xe336}, {0x8e66,0xe337}, {0x8e67,0xe338},
    {0x8e68,0xe339}, {0x8e69,0xe33a}, {0x8e6a,0xe33b}, {0x8e6b,0xe33c}, {0x8e6c,0xe33d}, {0x8e6d,0xe33e}, {0x8e6e,0xe33f}, {0x8e6f,0xe340}, {0x8e70,0xe341}, {0x8e71,0xe342},
    {0x8e72,0xe343}, {0x8e73,0xe344}, {0x8e74,0xe345}, {0x8e75,0xe346}, {0x8e76,0xe347}, {0x8e77,0xe348}, {0x8e78,0xe349}, {0x8e79,0xe34a}, {0x8e7a,0xe34b}, {0x8e7b,0xe34c},
    {0x8e7c,0xe34d}, {0x8e7d,0xe34e}, {0x8e7e,0xe34f}, {0x8ea1,0xe350}, {0x8ea2,0xe351}, {0x8ea3,0xe352}, {0x8ea4,0xe353}, {0x8ea5,0xe354}, {0x8ea6,0xe355}, {0x8ea7,0xe356},
    {0x8ea8,0xe357}, {0x8ea9,0xe358}, {0x8eaa,0xe359}, {0x8eab,0xe35a}, {0x8eac,0xe35b}, {0x8ead,0xe35c}, {0x8eae,0xe35d}, {0x8eaf,0xe35e}, {0x8eb0,0xe35f}, {0x8eb1,0xe360},
    {0x8eb2,0xe361}, {0x8eb3,0xe362}, {0x8eb4,0xe363}, {0x8eb5,0xe364}, {0x8eb6,0xe365}, {0x8eb7,0xe366}, {0x8eb8,0xe367}, {0x8eb9,0xe368}, {0x8eba,0xe369}, {0x8ebb,0xe36a},
    {0x8ebc,0xe36b}, {0x8ebd,0xe36c}, {0x8ebe,0xe36d}, {0x8ebf,0xe36e}, {0x8ec0,0xe36f}, {0x8ec1,0xe370}, {0x8ec2,0xe371}, {0x8ec3,0xe372}, {0x8ec4,0xe373}, {0x8ec5,0xe374},
    {0x8ec6,0xe375}, {0x8ec7,0xe376}, {0x8ec8,0xe377}, {0x8ec9,0xe378}, {0x8eca,0xe379}, {0x8ecb,0xe37a}, {0x8ecc,0xe37b}, {0x8ecd,0xe37c}, {0x8ece,0xe37d}, {0x8ecf,0xe37e},
    {0x8ed0,0xe37f}, {0x8ed1,0xe380}, {0x8ed2,0xe381}, {0x8ed3,0xe382}, {0x8ed4,0xe383}, {0x8ed5,0xe384}, {0x8ed6,0xe385}, {0x8ed7,0xe386}, {0x8ed8,0xe387}, {0x8ed9,0xe388},
    {0x8eda,0xe389}, {0x8edb,0xe38a}, {0x8edc,0xe38b}, {0x8edd,0xe38c}, {0x8ede,0xe38d}, {0x8edf,0xe38e}, {0x8ee0,0xe38f}, {0x8ee1,0xe390}, {0x8ee2,0xe391}, {0x8ee3,0xe392},
    {0x8ee4,0xe393}, {0x8ee5,0xe394}, {0x8ee6,0xe395}, {0x8ee7,0xe396}, {0x8ee8,0xe397}, {0x8ee9,0xe398}, {0x8eea,0xe399}, {0x8eeb,0xe39a}, {0x8eec,0xe39b}, {0x8eed,0xe39c},
    {0x8eee,0xe39d}, {0x8eef,0xe39e}, {0x8ef0,0xe39f}, {0x8ef1,0xe3a0}, {0x8ef2,0xe3a1}, {0x8ef3,0xe3a2}, {0x8ef4,0xe3a3}, {0x8ef5,0xe3a4}, {0x8ef6,0xe3a5}, {0x8ef7,0xe3a6},
    {0x8ef8,0xe3a7}, {0x8ef9,0xe3a8}, {0x8efa,0xe3a9}, {0x8efb,0xe3aa}, {0x8efc,0xe3ab}, {0x8efd,0xe3ac}, {0x8efe,0xe3ad}, {0x8f40,0xe3ae}, {0x8f41,0xe3af}, {0x8f42,0xe3b0},
    {0x8f43,0xe3b1}, {0x8f44,0xe3b2}, {0x8f45,0xe3b3}, {0x8f46,0xe3b4}, {0x8f47,0xe3b5}, {0x8f48,0xe3b6}, {0x8f49,0xe3b7}, {0x8f4a,0xe3b8}, {0x8f4b,0xe3b9}, {0x8f4c,0xe3ba},
    {0x8f4d,0xe3bb}, {0x8f4e,0xe3bc}, {0x8f4f,0xe3bd}, {0x8f50,0xe3be}, {0x8f51,0xe3bf}, {0x8f52,0xe3c0}, {0x8f53,0xe3c1}, {0x8f54,0xe3c2}, {0x8f55,0xe3c3}, {0x8f56,0xe3c4},
    {0x8f57,0xe3c5}, {0x8f58,0xe3c6}, {0x8f59,0xe3c7}, {0x8f5a,0xe3c8}, {0x8f5b,0xe3c9}, {0x8f5c,0xe3ca}, {0x8f5d,0xe3cb}, {0x8f5e,0xe3cc}, {0x8f5f,0xe3cd}, {0x8f60,0xe3ce},
    {0x8f61,0xe3cf}, {0x8f62,0xe3d0}, {0x8f63,0xe3d1}, {0x8f64,0xe3d2}, {0x8f65,0xe3d3}, {0x8f66,0xe3d4}, {0x8f67,0xe3d5}, {0x8f68,0xe3d6}, {0x8f69,0xe3d7}, {0x8f6a,0xe3d8},
    {0x8f6b,0xe3d9}, {0x8f6c,0xe3da}, {0x8f6d,0xe3db}, {0x8f6e,0xe3dc}, {0x8f6f,0xe3dd}, {0x8f70,0xe3de}, {0x8f71,0xe3df}, {0x8f72,0xe3e0}, {0x8f73,0xe3e1}, {0x8f74,0xe3e2},
    {0x8f75,0xe3e3}, {0x8f76,0xe3e4}, {0x8f77,0xe3e5}, {0x8f78,0xe3e6}, {0x8f79,0xe3e7}, {0x8f7a,0xe3e8}, {0x8f7b,0xe3e9}, {0x8f7c,0xe3ea}, {0x8f7d,0xe3eb}, {0x8f7e,0xe3ec},
    {0x8fa1,0xe3ed}, {0x8fa2,0xe3ee}, {0x8fa3,0xe3ef}, {0x8fa4,0xe3f0}, {0x8fa5,0xe3f1}, {0x8fa6,0xe3f2}, {0x8fa7,0xe3f3}, {0x8fa8,0xe3f4}, {0x8fa9,0xe3f5}, {0x8faa,0xe3f6},
    {0x8fab,0xe3f7}, {0x8fac,0xe3f8}, {0x8fad,0xe3f9}, {0x8fae,0xe3fa}, {0x8faf,0xe3fb}, {0x8fb0,0xe3fc}, {0x8fb1,0xe3fd}, {0x8fb2,0xe3fe}, {0x8fb3,0xe3ff}, {0x8fb4,0xe400},
    {0x8fb5,0xe401}, {0x8fb6,0xe402}, {0x8fb7,0xe403}, {0x8fb8,0xe404}, {0x8fb9,0xe405}, {0x8fba,0xe406}, {0x8fbb,0xe407}, {0x8fbc,0xe408}, {0x8fbd,0xe409}, {0x8fbe,0xe40a},
    {0x8fbf,0xe40b}, {0x8fc0,0xe40c}, {0x8fc1,0xe40d}, {0x8fc2,0xe40e}, {0x8fc3,0xe40f}, {0x8fc4,0xe410}, {0x8fc5,0xe411}, {0x8fc6,0xe412}, {0x8fc7,0xe413}, {0x8fc8,0xe414},
    {0x8fc9,0xe415}, {0x8fca,0xe416}, {0x8fcb,0xe417}, {0x8fcc,0xe418}, {0x8fcd,0xe419}, {0x8fce,0xe41a}, {0x8fcf,0xe41b}, {0x8fd0,0xe41c}, {0x8fd1,0xe41d}, {0x8fd2,0xe41e},
    {0x8fd3,0xe41f}, {0x8fd4,0xe420}, {0x8fd5,0xe421}, {0x8fd6,0xe422}, {0x8fd7,0xe423}, {0x8fd8,0xe424}, {0x8fd9,0xe425}, {0x8fda,0xe426}, {0x8fdb,0xe427}, {0x8fdc,0xe428},
    {0x8fdd,0xe429}, {0x8fde,0xe42a}, {0x8fdf,0xe42b}, {0x8fe0,0xe42c}, {0x8fe1,0xe42d}, {0x8fe2,0xe42e}, {0x8fe3,0xe42f}, {0x8fe4,0xe430}, {0x8fe5,0xe431}, {0x8fe6,0xe432},
    {0x8fe7,0xe433}, {0x8fe8,0xe434}, {0x8fe9,0xe435}, {0x8fea,0xe436}, {0x8feb,0xe437}, {0x8fec,0xe438}, {0x8fed,0xe439}, {0x8fee,0xe43a}, {0x8fef,0xe43b}, {0x8ff0,0xe43c},
    {0x8ff1,0xe43d}, {0x8ff2,0xe43e}, {0x8ff3,0xe43f}, {0x8ff4,0xe440}, {0x8ff5,0xe441}, {0x8ff6,0xe442}, {0x8ff7,0xe443}, {0x8ff8,0xe444}, {0x8ff9,0xe445}, {0x8ffa,0xe446},
    {0x8ffb,0xe447}, {0x8ffc,0xe448}, {0x8ffd,0xe449}, {0x8ffe,0xe44a}, {0x9040,0xe44b}, {0x9041,0xe44c}, {0x9042,0xe44d}, {0x9043,0xe44e}, {0x9044,0xe44f}, {0x9045,0xe450},
    {0x9046,0xe451}, {0x9047,0xe452}, {0x9048,0xe453}, {0x9049,0xe454}, {0x904a,0xe455}, {0x904b,0xe456}, {0x904c,0xe457}, {0x904d,0xe458}, {0x904e,0xe459}, {0x904f,0xe45a},
    {0x9050,0xe45b}, {0x9051,0xe45c}, {0x9052,0xe45d}, {0x9053,0xe45e}, {0x9054,0xe45f}, {0x9055,0xe460}, {0x9056,0xe461}, {0x9057,0xe462}, {0x9058,0xe463}, {0x9059,0xe464},
    {0x905a,0xe465}, {0x905b,0xe466}, {0x905c,0xe467}, {0x905d,0xe468}, {0x905e,0xe469}, {0x905f,0xe46a}, {0x9060,0xe46b}, {0x9061,0xe46c}, {0x9062,0xe46d}, {0x9063,0xe46e},
    {0x9064,0xe46f}, {0x9065,0xe470}, {0x9066,0xe471}, {0x9067,0xe472}, {0x9068,0xe473}, {0x9069,0xe474}, {0x906a,0xe475}, {0x906b,0xe476}, {0x906c,0xe477}, {0x906d,0xe478},
    {0x906e,0xe479}, {0x906f,0xe47a}, {0x9070,0xe47b}, {0x9071,0xe47c}, {0x9072,0xe47d}, {0x9073,0xe47e}, {0x9074,0xe47f}, {0x9075,0xe480}, {0x9076,0xe481}, {0x9077,0xe482},
    {0x9078,0xe483}, {0x9079,0xe484}, {0x907a,0xe485}, {0x907b,0xe486}, {0x907c,0xe487}, {0x907d,0xe488}, {0x907e,0xe489}, {0x90a1,0xe48a}, {0x90a2,0xe48b}, {0x90a3,0xe48c},
    {0x90a4,0xe48d}, {0x90a5,0xe48e}, {0x90a6,0xe48f}, {0x90a7,0xe490}, {0x90a8,0xe491}, {0x90a9,0xe492}, {0x90aa,0xe493}, {0x90ab,0xe494}, {0x90ac,0xe495}, {0x90ad,0xe496},
    {0x90ae,0xe497}, {0x90af,0xe498}, {0x90b0,0xe499}, {0x90b1,0xe49a}, {0x90b2,0xe49b}, {0x90b3,0xe49c}, {0x90b4,0xe49d}, {0x90b5,0xe49e}, {0x90b6,0xe49f}, {0x90b7,0xe4a0},
    {0x90b8,0xe4a1}, {0x90b9,0xe4a2}, {0x90ba,0xe4a3}, {0x90bb,0xe4a4}, {0x90bc,0xe4a5}, {0x90bd,0xe4a6}, {0x90be,0xe4a7}, {0x90bf,0xe4a8}, {0x90c0,0xe4a9}, {0x90c1,0xe4aa},
    {0x90c2,0xe4ab}, {0x90c3,0xe4ac}, {0x90c4,0xe4ad}, {0x90c5,0xe4ae}, {0x90c6,0xe4af}, {0x90c7,0xe4b0}, {0x90c8,0xe4b1}, {0x90c9,0xe4b2}, {0x90ca,0xe4b3}, {0x90cb,0xe4b4},
    {0x90cc,0xe4b5}, {0x90cd,0xe4b6}, {0x90ce,0xe4b7}, {0x90cf,0xe4b8}, {0x90d0,0xe4b9}, {0x90d1,0xe4ba}, {0x90d2,0xe4bb}, {0x90d3,0xe4bc}, {0x90d4,0xe4bd}, {0x90d5,0xe4be},
    {0x90d6,0xe4bf}, {0x90d7,0xe4c0}, {0x90d8,0xe4c1}, {0x90d9,0xe4c2}, {0x90da,0xe4c3}, {0x90db,0xe4c4}, {0x90dc,0xe4c5}, {0x90dd,0xe4c6}, {0x90de,0xe4c7}, {0x90df,0xe4c8},
    {0x90e0,0xe4c9}, {0x90e1,0xe4ca}, {0x90e2,0xe4cb}, {0x90e3,0xe4cc}, {0x90e4,0xe4cd}, {0x90e5,0xe4ce}, {0x90e6,0xe4cf}, {0x90e7,0xe4d0}, {0x90e8,0xe4d1}, {0x90e9,0xe4d2},
    {0x90ea,0xe4d3}, {0x90eb,0xe4d4}, {0x90ec,0xe4d5}, {0x90ed,0xe4d6}, {0x90ee,0xe4d7}, {0x90ef,0xe4d8}, {0x90f0,0xe4d9}, {0x90f1,0xe4da}, {0x90f2,0xe4db}, {0x90f3,0xe4dc},
    {0x90f4,0xe4dd}, {0x90f5,0xe4de}, {0x90f6,0xe4df}, {0x90f7,0xe4e0}, {0x90f8,0xe4e1}, {0x90f9,0xe4e2}, {0x90fa,0xe4e3}, {0x90fb,0xe4e4}, {0x90fc,0xe4e5}, {0x90fd,0xe4e6},
    {0x90fe,0xe4e7}, {0x9140,0xe4e8}, {0x9141,0xe4e9}, {0x9142,0xe4ea}, {0x9143,0xe4eb}, {0x9144,0xe4ec}, {0x9145,0xe4ed}, {0x9146,0xe4ee}, {0x9147,0xe4ef}, {0x9148,0xe4f0},
    {0x9149,0xe4f1}, {0x914a,0xe4f2}, {0x914b,0xe4f3}, {0x914c,0xe4f4}, {0x914d,0xe4f5}, {0x914e,0xe4f6}, {0x914f,0xe4f7}, {0x9150,0xe4f8}, {0x9151,0xe4f9}, {0x9152,0xe4fa},
    {0x9153,0xe4fb}, {0x9154,0xe4fc}, {0x9155,0xe4fd}, {0x9156,0xe4fe}, {0x9157,0xe4ff}, {0x9158,0xe500}, {0x9159,0xe501}, {0x915a,0xe502}, {0x915b,0xe503}, {0x915c,0xe504},
    {0x915d,0xe505}, {0x915e,0xe506}, {0x915f,0xe507}, {0x9160,0xe508}, {0x9161,0xe509}, {0x9162,0xe50a}, {0x9163,0xe50b}, {0x9164,0xe50c}, {0x9165,0xe50d}, {0x9166,0xe50e},
    {0x9167,0xe50f}, {0x9168,0xe510}, {0x9169,0xe511}, {0x916a,0xe512}, {0x916b,0xe513}, {0x916c,0xe514}, {0x916d,0xe515}, {0x916e,0xe516}, {0x916f,0xe517}, {0x9170,0xe518},
    {0x9171,0xe519}, {0x9172,0xe51a}, {0x9173,0xe51b}, {0x9174,0xe51c}, {0x9175,0xe51d}, {0x9176,0xe51e}, {0x9177,0xe51f}, {0x9178,0xe520}, {0x9179,0xe521}, {0x917a,0xe522},
    {0x917b,0xe523}, {0x917c,0xe524}, {0x917d,0xe525}, {0x917e,0xe526}, {0x91a1,0xe527}, {0x91a2,0xe528}, {0x91a3,0xe529}, {0x91a4,0xe52a}, {0x91a5,0xe52b}, {0x91a6,0xe52c},
    {0x91a7,0xe52d}, {0x91a8,0xe52e}, {0x91a9,0xe52f}, {0x91aa,0xe530}, {0x91ab,0xe531}, {0x91ac,0xe532}, {0x91ad,0xe533}, {0x91ae,0xe534}, {0x91af,0xe535}, {0x91b0,0xe536},
    {0x91b1,0xe537}, {0x91b2,0xe538}, {0x91b3,0xe539}, {0x91b4,0xe53a}, {0x91b5,0xe53b}, {0x91b6,0xe53c}, {0x91b7,0xe53d}, {0x91b8,0xe53e}, {0x91b9,0xe53f}, {0x91ba,0xe540},
    {0x91bb,0xe541}, {0x91bc,0xe542}, {0x91bd,0xe543}, {0x91be,0xe544}, {0x91bf,0xe545}, {0x91c0,0xe546}, {0x91c1,0xe547}, {0x91c2,0xe548}, {0x91c3,0xe549}, {0x91c4,0xe54a},
    {0x91c5,0xe54b}, {0x91c6,0xe54c}, {0x91c7,0xe54d}, {0x91c8,0xe54e}, {0x91c9,0xe54f}, {0x91ca,0xe550}, {0x91cb,0xe551}, {0x91cc,0xe552}, {0x91cd,0xe553}, {0x91ce,0xe554},
    {0x91cf,0xe555}, {0x91d0,0xe556}, {0x91d1,0xe557}, {0x91d2,0xe558}, {0x91d3,0xe559}, {0x91d4,0xe55a}, {0x91d5,0xe55b}, {0x91d6,0xe55c}, {0x91d7,0xe55d}, {0x91d8,0xe55e},
    {0x91d9,0xe55f}, {0x91da,0xe560}, {0x91db,0xe561}, {0x91dc,0xe562}, {0x91dd,0xe563}, {0x91de,0xe564}, {0x91df,0xe565}, {0x91e0,0xe566}, {0x91e1,0xe567}, {0x91e2,0xe568},
    {0x91e3,0xe569}, {0x91e4,0xe56a}, {0x91e5,0xe56b}, {0x91e6,0xe56c}, {0x91e7,0xe56d}, {0x91e8,0xe56e}, {0x91e9,0xe56f}, {0x91ea,0xe570}, {0x91eb,0xe571}, {0x91ec,0xe572},
    {0x91ed,0xe573}, {0x91ee,0xe574}, {0x91ef,0xe575}, {0x91f0,0xe576}, {0x91f1,0xe577}, {0x91f2,0xe578}, {0x91f3,0xe579}, {0x91f4,0xe57a}, {0x91f5,0xe57b}, {0x91f6,0xe57c},
    {0x91f7,0xe57d}, {0x91f8,0xe57e}, {0x91f9,0xe57f}, {0x91fa,0xe580}, {0x91fb,0xe581}, {0x91fc,0xe582}, {0x91fd,0xe583}, {0x91fe,0xe584}, {0x9240,0xe585}, {0x9241,0xe586},
    {0x9242,0xe587}, {0x9243,0xe588}, {0x9244,0xe589}, {0x9245,0xe58a}, {0x9246,0xe58b}, {0x9247,0xe58c}, {0x9248,0xe58d}, {0x9249,0xe58e}, {0x924a,0xe58f}, {0x924b,0xe590},
    {0x924c,0xe591}, {0x924d,0xe592}, {0x924e,0xe593}, {0x924f,0xe594}, {0x9250,0xe595}, {0x9251,0xe596}, {0x9252,0xe597}, {0x9253,0xe598}, {0x9254,0xe599}, {0x9255,0xe59a},
    {0x9256,0xe59b}, {0x9257,0xe59c}, {0x9258,0xe59d}, {0x9259,0xe59e}, {0x925a,0xe59f}, {0x925b,0xe5a0}, {0x925c,0xe5a1}, {0x925d,0xe5a2}, {0x925e,0xe5a3}, {0x925f,0xe5a4},
    {0x9260,0xe5a5}, {0x9261,0xe5a6}, {0x9262,0xe5a7}, {0x9263,0xe5a8}, {0x9264,0xe5a9}, {0x9265,0xe5aa}, {0x9266,0xe5ab}, {0x9267,0xe5ac}, {0x9268,0xe5ad}, {0x9269,0xe5ae},
    {0x926a,0xe5af}, {0x926b,0xe5b0}, {0x926c,0xe5b1}, {0x926d,0xe5b2}, {0x926e,0xe5b3}, {0x926f,0xe5b4}, {0x9270,0xe5b5}, {0x9271,0xe5b6}, {0x9272,0xe5b7}, {0x9273,0xe5b8},
    {0x9274,0xe5b9}, {0x9275,0xe5ba}, {0x9276,0xe5bb}, {0x9277,0xe5bc}, {0x9278,0xe5bd}, {0x9279,0xe5be}, {0x927a,0xe5bf}, {0x927b,0xe5c0}, {0x927c,0xe5c1}, {0x927d,0xe5c2},
    {0x927e,0xe5c3}, {0x92a1,0xe5c4}, {0x92a2,0xe5c5}, {0x92a3,0xe5c6}, {0x92a4,0xe5c7}, {0x92a5,0xe5c8}, {0x92a6,0xe5c9}, {0x92a7,0xe5ca}, {0x92a8,0xe5cb}, {0x92a9,0xe5cc},
    {0x92aa,0xe5cd}, {0x92ab,0xe5ce}, {0x92ac,0xe5cf}, {0x92ad,0xe5d0}, {0x92ae,0xe5d1}, {0x92af,0xe5d2}, {0x92b0,0xe5d3}, {0x92b1,0xe5d4}, {0x92b2,0xe5d5}, {0x92b3,0xe5d6},
    {0x92b4,0xe5d7}, {0x92b5,0xe5d8}, {0x92b6,0xe5d9}, {0x92b7,0xe5da}, {0x92b8,0xe5db}, {0x92b9,0xe5dc}, {0x92ba,0xe5dd}, {0x92bb,0xe5de}, {0x92bc,0xe5df}, {0x92bd,0xe5e0},
    {0x92be,0xe5e1}, {0x92bf,0xe5e2}, {0x92c0,0xe5e3}, {0x92c1,0xe5e4}, {0x92c2,0xe5e5}, {0x92c3,0xe5e6}, {0x92c4,0xe5e7}, {0x92c5,0xe5e8}, {0x92c6,0xe5e9}, {0x92c7,0xe5ea},
    {0x92c8,0xe5eb}, {0x92c9,0xe5ec}, {0x92ca,0xe5ed}, {0x92cb,0xe5ee}, {0x92cc,0xe5ef}, {0x92cd,0xe5f0}, {0x92ce,0xe5f1}, {0x92cf,0xe5f2}, {0x92d0,0xe5f3}, {0x92d1,0xe5f4},
    {0x92d2,0xe5f5}, {0x92d3,0xe5f6}, {0x92d4,0xe5f7}, {0x92d5,0xe5f8}, {0x92d6,0xe5f9}, {0x92d7,0xe5fa}, {0x92d8,0xe5fb}, {0x92d9,0xe5fc}, {0x92da,0xe5fd}, {0x92db,0xe5fe},
    {0x92dc,0xe5ff}, {0x92dd,0xe600}, {0x92de,0xe601}, {0x92df,0xe602}, {0x92e0,0xe603}, {0x92e1,0xe604}, {0x92e2,0xe605}, {0x92e3,0xe606}, {0x92e4,0xe607}, {0x92e5,0xe608},
    {0x92e6,0xe609}, {0x92e7,0xe60a}, {0x92e8,0xe60b}, {0x92e9,0xe60c}, {0x92ea,0xe60d}, {0x92eb,0xe60e}, {0x92ec,0xe60f}, {0x92ed,0xe610}, {0x92ee,0xe611}, {0x92ef,0xe612},
    {0x92f0,0xe613}, {0x92f1,0xe614}, {0x92f2,0xe615}, {0x92f3,0xe616}, {0x92f4,0xe617}, {0x92f5,0xe618}, {0x92f6,0xe619}, {0x92f7,0xe61a}, {0x92f8,0xe61b}, {0x92f9,0xe61c},
    {0x92fa,0xe61d}, {0x92fb,0xe61e}, {0x92fc,0xe61f}, {0x92fd,0xe620}, {0x92fe,0xe621}, {0x9340,0xe622}, {0x9341,0xe623}, {0x9342,0xe624}, {0x9343,0xe625}, {0x9344,0xe626},
    {0x9345,0xe627}, {0x9346,0xe628}, {0x9347,0xe629}, {0x9348,0xe62a}, {0x9349,0xe62b}, {0x934a,0xe62c}, {0x934b,0xe62d}, {0x934c,0xe62e}, {0x934d,0xe62f}, {0x934e,0xe630},
    {0x934f,0xe631}, {0x9350,0xe632}, {0x9351,0xe633}, {0x9352,0xe634}, {0x9353,0xe635}, {0x9354,0xe636}, {0x9355,0xe637}, {0x9356,0xe638}, {0x9357,0xe639}, {0x9358,0xe63a},
    {0x9359,0xe63b}, {0x935a,0xe63c}, {0x935b,0xe63d}, {0x935c,0xe63e}, {0x935d,0xe63f}, {0x935e,0xe640}, {0x935f,0xe641}, {0x9360,0xe642}, {0x9361,0xe643}, {0x9362,0xe644},
    {0x9363,0xe645}, {0x9364,0xe646}, {0x9365,0xe647}, {0x9366,0xe648}, {0x9367,0xe649}, {0x9368,0xe64a}, {0x9369,0xe64b}, {0x936a,0xe64c}, {0x936b,0xe64d}, {0x936c,0xe64e},
    {0x936d,0xe64f}, {0x936e,0xe650}, {0x936f,0xe651}, {0x9370,0xe652}, {0x9371,0xe653}, {0x9372,0xe654}, {0x9373,0xe655}, {0x9374,0xe656}, {0x9375,0xe657}, {0x9376,0xe658},
    {0x9377,0xe659}, {0x9378,0xe65a}, {0x9379,0xe65b}, {0x937a,0xe65c}, {0x937b,0xe65d}, {0x937c,0xe65e}, {0x937d,0xe65f}, {0x937e,0xe660}, {0x93a1,0xe661}, {0x93a2,0xe662},
    {0x93a3,0xe663}, {0x93a4,0xe664}, {0x93a5,0xe665}, {0x93a6,0xe666}, {0x93a7,0xe667}, {0x93a8,0xe668}, {0x93a9,0xe669}, {0x93aa,0xe66a}, {0x93ab,0xe66b}, {0x93ac,0xe66c},
    {0x93ad,0xe66d}, {0x93ae,0xe66e}, {0x93af,0xe66f}, {0x93b0,0xe670}, {0x93b1,0xe671}, {0x93b2,0xe672}, {0x93b3,0xe673}, {0x93b4,0xe674}, {0x93b5,0xe675}, {0x93b6,0xe676},
    {0x93b7,0xe677}, {0x93b8,0xe678}, {0x93b9,0xe679}, {0x93ba,0xe67a}, {0x93bb,0xe67b}, {0x93bc,0xe67c}, {0x93bd,0xe67d}, {0x93be,0xe67e}, {0x93bf,0xe67f}, {0x93c0,0xe680},
    {0x93c1,0xe681}, {0x93c2,0xe682}, {0x93c3,0xe683}, {0x93c4,0xe684}, {0x93c5,0xe685}, {0x93c6,0xe686}, {0x93c7,0xe687}, {0x93c8,0xe688}, {0x93c9,0xe689}, {0x93ca,0xe68a},
    {0x93cb,0xe68b}, {0x93cc,0xe68c}, {0x93cd,0xe68d}, {0x93ce,0xe68e}, {0x93cf,0xe68f}, {0x93d0,0xe690}, {0x93d1,0xe691}, {0x93d2,0xe692}, {0x93d3,0xe693}, {0x93d4,0xe694},
    {0x93d5,0xe695}, {0x93d6,0xe696}, {0x93d7,0xe697}, {0x93d8,0xe698}, {0x93d9,0xe699}, {0x93da,0xe69a}, {0x93db,0xe69b}, {0x93dc,0xe69c}, {0x93dd,0xe69d}, {0x93de,0xe69e},
    {0x93df,0xe69f}, {0x93e0,0xe6a0}, {0x93e1,0xe6a1}, {0x93e2,0xe6a2}, {0x93e3,0xe6a3}, {0x93e4,0xe6a4}, {0x93e5,0xe6a5}, {0x93e6,0xe6a6}, {0x93e7,0xe6a7}, {0x93e8,0xe6a8},
    {0x93e9,0xe6a9}, {0x93ea,0xe6aa}, {0x93eb,0xe6ab}, {0x93ec,0xe6ac}, {0x93ed,0xe6ad}, {0x93ee,0xe6ae}, {0x93ef,0xe6af}, {0x93f0,0xe6b0}, {0x93f1,0xe6b1}, {0x93f2,0xe6b2},
    {0x93f3,0xe6b3}, {0x93f4,0xe6b4}, {0x93f5,0xe6b5}, {0x93f6,0xe6b6}, {0x93f7,0xe6b7}, {0x93f8,0xe6b8}, {0x93f9,0xe6b9}, {0x93fa,0xe6ba}, {0x93fb,0xe6bb}, {0x93fc,0xe6bc},
    {0x93fd,0xe6bd}, {0x93fe,0xe6be}, {0x9440,0xe6bf}, {0x9441,0xe6c0}, {0x9442,0xe6c1}, {0x9443,0xe6c2}, {0x9444,0xe6c3}, {0x9445,0xe6c4}, {0x9446,0xe6c5}, {0x9447,0xe6c6},
    {0x9448,0xe6c7}, {0x9449,0xe6c8}, {0x944a,0xe6c9}, {0x944b,0xe6ca}, {0x944c,0xe6cb}, {0x944d,0xe6cc}, {0x944e,0xe6cd}, {0x944f,0xe6ce}, {0x9450,0xe6cf}, {0x9451,0xe6d0},
    {0x9452,0xe6d1}, {0x9453,0xe6d2}, {0x9454,0xe6d3}, {0x9455,0xe6d4}, {0x9456,0xe6d5}, {0x9457,0xe6d6}, {0x9458,0xe6d7}, {0x9459,0xe6d8}, {0x945a,0xe6d9}, {0x945b,0xe6da},
    {0x945c,0xe6db}, {0x945d,0xe6dc}, {0x945e,0xe6dd}, {0x945f,0xe6de}, {0x9460,0xe6df}, {0x9461,0xe6e0}, {0x9462,0xe6e1}, {0x9463,0xe6e2}, {0x9464,0xe6e3}, {0x9465,0xe6e4},
    {0x9466,0xe6e5}, {0x9467,0xe6e6}, {0x9468,0xe6e7}, {0x9469,0xe6e8}, {0x946a,0xe6e9}, {0x946b,0xe6ea}, {0x946c,0xe6eb}, {0x946d,0xe6ec}, {0x946e,0xe6ed}, {0x946f,0xe6ee},
    {0x9470,0xe6ef}, {0x9471,0xe6f0}, {0x9472,0xe6f1}, {0x9473,0xe6f2}, {0x9474,0xe6f3}, {0x9475,0xe6f4}, {0x9476,0xe6f5}, {0x9477,0xe6f6}, {0x9478,0xe6f7}, {0x9479,0xe6f8},
    {0x947a,0xe6f9}, {0x947b,0xe6fa}, {0x947c,0xe6fb}, {0x947d,0xe6fc}, {0x947e,0xe6fd}, {0x94a1,0xe6fe}, {0x94a2,0xe6ff}, {0x94a3,0xe700}, {0x94a4,0xe701}, {0x94a5,0xe702},
    {0x94a6,0xe703}, {0x94a7,0xe704}, {0x94a8,0xe705}, {0x94a9,0xe706}, {0x94aa,0xe707}, {0x94ab,0xe708}, {0x94ac,0xe709}, {0x94ad,0xe70a}, {0x94ae,0xe70b}, {0x94af,0xe70c},
    {0x94b0,0xe70d}, {0x94b1,0xe70e}, {0x94b2,0xe70f}, {0x94b3,0xe710}, {0x94b4,0xe711}, {0x94b5,0xe712}, {0x94b6,0xe713}, {0x94b7,0xe714}, {0x94b8,0xe715}, {0x94b9,0xe716},
    {0x94ba,0xe717}, {0x94bb,0xe718}, {0x94bc,0xe719}, {0x94bd,0xe71a}, {0x94be,0xe71b}, {0x94bf,0xe71c}, {0x94c0,0xe71d}, {0x94c1,0xe71e}, {0x94c2,0xe71f}, {0x94c3,0xe720},
    {0x94c4,0xe721}, {0x94c5,0xe722}, {0x94c6,0xe723}, {0x94c7,0xe724}, {0x94c8,0xe725}, {0x94c9,0xe726}, {0x94ca,0xe727}, {0x94cb,0xe728}, {0x94cc,0xe729}, {0x94cd,0xe72a},
    {0x94ce,0xe72b}, {0x94cf,0xe72c}, {0x94d0,0xe72d}, {0x94d1,0xe72e}, {0x94d2,0xe72f}, {0x94d3,0xe730}, {0x94d4,0xe731}, {0x94d5,0xe732}, {0x94d6,0xe733}, {0x94d7,0xe734},
    {0x94d8,0xe735}, {0x94d9,0xe736}, {0x94da,0xe737}, {0x94db,0xe738}, {0x94dc,0xe739}, {0x94dd,0xe73a}, {0x94de,0xe73b}, {0x94df,0xe73c}, {0x94e0,0xe73d}, {0x94e1,0xe73e},
    {0x94e2,0xe73f}, {0x94e3,0xe740}, {0x94e4,0xe741}, {0x94e5,0xe742}, {0x94e6,0xe743}, {0x94e7,0xe744}, {0x94e8,0xe745}, {0x94e9,0xe746}, {0x94ea,0xe747}, {0x94eb,0xe748},
    {0x94ec,0xe749}, {0x94ed,0xe74a}, {0x94ee,0xe74b}, {0x94ef,0xe74c}, {0x94f0,0xe74d}, {0x94f1,0xe74e}, {0x94f2,0xe74f}, {0x94f3,0xe750}, {0x94f4,0xe751}, {0x94f5,0xe752},
    {0x94f6,0xe753}, {0x94f7,0xe754}, {0x94f8,0xe755}, {0x94f9,0xe756}, {0x94fa,0xe757}, {0x94fb,0xe758}, {0x94fc,0xe759}, {0x94fd,0xe75a}, {0x94fe,0xe75b}, {0x9540,0xe75c},
    {0x9541,0xe75d}, {0x9542,0xe75e}, {0x9543,0xe75f}, {0x9544,0xe760}, {0x9545,0xe761}, {0x9546,0xe762}, {0x9547,0xe763}, {0x9548,0xe764}, {0x9549,0xe765}, {0x954a,0xe766},
    {0x954b,0xe767}, {0x954c,0xe768}, {0x954d,0xe769}, {0x954e,0xe76a}, {0x954f,0xe76b}, {0x9550,0xe76c}, {0x9551,0xe76d}, {0x9552,0xe76e}, {0x9553,0xe76f}, {0x9554,0xe770},
    {0x9555,0xe771}, {0x9556,0xe772}, {0x9557,0xe773}, {0x9558,0xe774}, {0x9559,0xe775}, {0x955a,0xe776}, {0x955b,0xe777}, {0x955c,0xe778}, {0x955d,0xe779}, {0x955e,0xe77a},
    {0x955f,0xe77b}, {0x9560,0xe77c}, {0x9561,0xe77d}, {0x9562,0xe77e}, {0x9563,0xe77f}, {0x9564,0xe780}, {0x9565,0xe781}, {0x9566,0xe782}, {0x9567,0xe783}, {0x9568,0xe784},
    {0x9569,0xe785}, {0x956a,0xe786}, {0x956b,0xe787}, {0x956c,0xe788}, {0x956d,0xe789}, {0x956e,0xe78a}, {0x956f,0xe78b}, {0x9570,0xe78c}, {0x9571,0xe78d}, {0x9572,0xe78e},
    {0x9573,0xe78f}, {0x9574,0xe790}, {0x9575,0xe791}, {0x9576,0xe792}, {0x9577,0xe793}, {0x9578,0xe794}, {0x9579,0xe795}, {0x957a,0xe796}, {0x957b,0xe797}, {0x957c,0xe798},
    {0x957d,0xe799}, {0x957e,0xe79a}, {0x95a1,0xe79b}, {0x95a2,0xe79c}, {0x95a3,0xe79d}, {0x95a4,0xe79e}, {0x95a5,0xe79f}, {0x95a6,0xe7a0}, {0x95a7,0xe7a1}, {0x95a8,0xe7a2},
    {0x95a9,0xe7a3}, {0x95aa,0xe7a4}, {0x95ab,0xe7a5}, {0x95ac,0xe7a6}, {0x95ad,0xe7a7}, {0x95ae,0xe7a8}, {0x95af,0xe7a9}, {0x95b0,0xe7aa}, {0x95b1,0xe7ab}, {0x95b2,0xe7ac},
    {0x95b3,0xe7ad}, {0x95b4,0xe7ae}, {0x95b5,0xe7af}, {0x95b6,0xe7b0}, {0x95b7,0xe7b1}, {0x95b8,0xe7b2}, {0x95b9,0xe7b3}, {0x95ba,0xe7b4}, {0x95bb,0xe7b5}, {0x95bc,0xe7b6},
    {0x95bd,0xe7b7}, {0x95be,0xe7b8}, {0x95bf,0xe7b9}, {0x95c0,0xe7ba}, {0x95c1,0xe7bb}, {0x95c2,0xe7bc}, {0x95c3,0xe7bd}, {0x95c4,0xe7be}, {0x95c5,0xe7bf}, {0x95c6,0xe7c0},
    {0x95c7,0xe7c1}, {0x95c8,0xe7c2}, {0x95c9,0xe7c3}, {0x95ca,0xe7c4}, {0x95cb,0xe7c5}, {0x95cc,0xe7c6}, {0x95cd,0xe7c7}, {0x95ce,0xe7c8}, {0x95cf,0xe7c9}, {0x95d0,0xe7ca},
    {0x95d1,0xe7cb}, {0x95d2,0xe7cc}, {0x95d3,0xe7cd}, {0x95d4,0xe7ce}, {0x95d5,0xe7cf}, {0x95d6,0xe7d0}, {0x95d7,0xe7d1}, {0x95d8,0xe7d2}, {0x95d9,0xe7d3}, {0x95da,0xe7d4},
    {0x95db,0xe7d5}, {0x95dc,0xe7d6}, {0x95dd,0xe7d7}, {0x95de,0xe7d8}, {0x95df,0xe7d9}, {0x95e0,0xe7da}, {0x95e1,0xe7db}, {0x95e2,0xe7dc}, {0x95e3,0xe7dd}, {0x95e4,0xe7de},
    {0x95e5,0xe7df}, {0x95e6,0xe7e0}, {0x95e7,0xe7e1}, {0x95e8,0xe7e2}, {0x95e9,0xe7e3}, {0x95ea,0xe7e4}, {0x95eb,0xe7e5}, {0x95ec,0xe7e6}, {0x95ed,0xe7e7}, {0x95ee,0xe7e8},
    {0x95ef,0xe7e9}, {0x95f0,0xe7ea}, {0x95f1,0xe7eb}, {0x95f2,0xe7ec}, {0x95f3,0xe7ed}, {0x95f4,0xe7ee}, {0x95f5,0xe7ef}, {0x95f6,0xe7f0}, {0x95f7,0xe7f1}, {0x95f8,0xe7f2},
    {0x95f9,0xe7f3}, {0x95fa,0xe7f4}, {0x95fb,0xe7f5}, {0x95fc,0xe7f6}, {0x95fd,0xe7f7}, {0x95fe,0xe7f8}, {0x9640,0xe7f9}, {0x9641,0xe7fa}, {0x9642,0xe7fb}, {0x9643,0xe7fc},
    {0x9644,0xe7fd}, {0x9645,0xe7fe}, {0x9646,0xe7ff}, {0x9647,0xe800}, {0x9648,0xe801}, {0x9649,0xe802}, {0x964a,0xe803}, {0x964b,0xe804}, {0x964c,0xe805}, {0x964d,0xe806},
    {0x964e,0xe807}, {0x964f,0xe808}, {0x9650,0xe809}, {0x9651,0xe80a}, {0x9652,0xe80b}, {0x9653,0xe80c}, {0x9654,0xe80d}, {0x9655,0xe80e}, {0x9656,0xe80f}, {0x9657,0xe810},
    {0x9658,0xe811}, {0x9659,0xe812}, {0x965a,0xe813}, {0x965b,0xe814}, {0x965c,0xe815}, {0x965d,0xe816}, {0x965e,0xe817}, {0x965f,0xe818}, {0x9660,0xe819}, {0x9661,0xe81a},
    {0x9662,0xe81b}, {0x9663,0xe81c}, {0x9664,0xe81d}, {0x9665,0xe81e}, {0x9666,0xe81f}, {0x9667,0xe820}, {0x9668,0xe821}, {0x9669,0xe822}, {0x966a,0xe823}, {0x966b,0xe824},
    {0x966c,0xe825}, {0x966d,0xe826}, {0x966e,0xe827}, {0x966f,0xe828}, {0x9670,0xe829}, {0x9671,0xe82a}, {0x9672,0xe82b}, {0x9673,0xe82c}, {0x9674,0xe82d}, {0x9675,0xe82e},
    {0x9676,0xe82f}, {0x9677,0xe830}, {0x9678,0xe831}, {0x9679,0xe832}, {0x967a,0xe833}, {0x967b,0xe834}, {0x967c,0xe835}, {0x967d,0xe836}, {0x967e,0xe837}, {0x96a1,0xe838},
    {0x96a2,0xe839}, {0x96a3,0xe83a}, {0x96a4,0xe83b}, {0x96a5,0xe83c}, {0x96a6,0xe83d}, {0x96a7,0xe83e}, {0x96a8,0xe83f}, {0x96a9,0xe840}, {0x96aa,0xe841}, {0x96ab,0xe842},
    {0x96ac,0xe843}, {0x96ad,0xe844}, {0x96ae,0xe845}, {0x96af,0xe846}, {0x96b0,0xe847}, {0x96b1,0xe848}, {0x96b2,0xe849}, {0x96b3,0xe84a}, {0x96b4,0xe84b}, {0x96b5,0xe84c},
    {0x96b6,0xe84d}, {0x96b7,0xe84e}, {0x96b8,0xe84f}, {0x96b9,0xe850}, {0x96ba,0xe851}, {0x96bb,0xe852}, {0x96bc,0xe853}, {0x96bd,0xe854}, {0x96be,0xe855}, {0x96bf,0xe856},
    {0x96c0,0xe857}, {0x96c1,0xe858}, {0x96c2,0xe859}, {0x96c3,0xe85a}, {0x96c4,0xe85b}, {0x96c5,0xe85c}, {0x96c6,0xe85d}, {0x96c7,0xe85e}, {0x96c8,0xe85f}, {0x96c9,0xe860},
    {0x96ca,0xe861}, {0x96cb,0xe862}, {0x96cc,0xe863}, {0x96cd,0xe864}, {0x96ce,0xe865}, {0x96cf,0xe866}, {0x96d0,0xe867}, {0x96d1,0xe868}, {0x96d2,0xe869}, {0x96d3,0xe86a},
    {0x96d4,0xe86b}, {0x96d5,0xe86c}, {0x96d6,0xe86d}, {0x96d7,0xe86e}, {0x96d8,0xe86f}, {0x96d9,0xe870}, {0x96da,0xe871}, {0x96db,0xe872}, {0x96dc,0xe873}, {0x96dd,0xe874},
    {0x96de,0xe875}, {0x96df,0xe876}, {0x96e0,0xe877}, {0x96e1,0xe878}, {0x96e2,0xe879}, {0x96e3,0xe87a}, {0x96e4,0xe87b}, {0x96e5,0xe87c}, {0x96e6,0xe87d}, {0x96e7,0xe87e},
    {0x96e8,0xe87f}, {0x96e9,0xe880}, {0x96ea,0xe881}, {0x96eb,0xe882}, {0x96ec,0xe883}, {0x96ed,0xe884}, {0x96ee,0xe885}, {0x96ef,0xe886}, {0x96f0,0xe887}, {0x96f1,0xe888},
    {0x96f2,0xe889}, {0x96f3,0xe88a}, {0x96f4,0xe88b}, {0x96f5,0xe88c}, {0x96f6,0xe88d}, {0x96f7,0xe88e}, {0x96f8,0xe88f}, {0x96f9,0xe890}, {0x96fa,0xe891}, {0x96fb,0xe892},
    {0x96fc,0xe893}, {0x96fd,0xe894}, {0x96fe,0xe895}, {0x9740,0xe896}, {0x9741,0xe897}, {0x9742,0xe898}, {0x9743,0xe899}, {0x9744,0xe89a}, {0x9745,0xe89b}, {0x9746,0xe89c},
    {0x9747,0xe89d}, {0x9748,0xe89e}, {0x9749,0xe89f}, {0x974a,0xe8a0}, {0x974b,0xe8a1}, {0x974c,0xe8a2}, {0x974d,0xe8a3}, {0x974e,0xe8a4}, {0x974f,0xe8a5}, {0x9750,0xe8a6},
    {0x9751,0xe8a7}, {0x9752,0xe8a8}, {0x9753,0xe8a9}, {0x9754,0xe8aa}, {0x9755,0xe8ab}, {0x9756,0xe8ac}, {0x9757,0xe8ad}, {0x9758,0xe8ae}, {0x9759,0xe8af}, {0x975a,0xe8b0},
    {0x975b,0xe8b1}, {0x975c,0xe8b2}, {0x975d,0xe8b3}, {0x975e,0xe8b4}, {0x975f,0xe8b5}, {0x9760,0xe8b6}, {0x9761,0xe8b7}, {0x9762,0xe8b8}, {0x9763,0xe8b9}, {0x9764,0xe8ba},
    {0x9765,0xe8bb}, {0x9766,0xe8bc}, {0x9767,0xe8bd}, {0x9768,0xe8be}, {0x9769,0xe8bf}, {0x976a,0xe8c0}, {0x976b,0xe8c1}, {0x976c,0xe8c2}, {0x976d,0xe8c3}, {0x976e,0xe8c4},
    {0x976f,0xe8c5}, {0x9770,0xe8c6}, {0x9771,0xe8c7}, {0x9772,0xe8c8}, {0x9773,0xe8c9}, {0x9774,0xe8ca}, {0x9775,0xe8cb}, {0x9776,0xe8cc}, {0x9777,0xe8cd}, {0x9778,0xe8ce},
    {0x9779,0xe8cf}, {0x977a,0xe8d0}, {0x977b,0xe8d1}, {0x977c,0xe8d2}, {0x977d,0xe8d3}, {0x977e,0xe8d4}, {0x97a1,0xe8d5}, {0x97a2,0xe8d6}, {0x97a3,0xe8d7}, {0x97a4,0xe8d8},
    {0x97a5,0xe8d9}, {0x97a6,0xe8da}, {0x97a7,0xe8db}, {0x97a8,0xe8dc}, {0x97a9,0xe8dd}, {0x97aa,0xe8de}, {0x97ab,0xe8df}, {0x97ac,0xe8e0}, {0x97ad,0xe8e1}, {0x97ae,0xe8e2},
    {0x97af,0xe8e3}, {0x97b0,0xe8e4}, {0x97b1,0xe8e5}, {0x97b2,0xe8e6}, {0x97b3,0xe8e7}, {0x97b4,0xe8e8}, {0x97b5,0xe8e9}, {0x97b6,0xe8ea}, {0x97b7,0xe8eb}, {0x97b8,0xe8ec},
    {0x97b9,0xe8ed}, {0x97ba,0xe8ee}, {0x97bb,0xe8ef}, {0x97bc,0xe8f0}, {0x97bd,0xe8f1}, {0x97be,0xe8f2}, {0x97bf,0xe8f3}, {0x97c0,0xe8f4}, {0x97c1,0xe8f5}, {0x97c2,0xe8f6},
    {0x97c3,0xe8f7}, {0x97c4,0xe8f8}, {0x97c5,0xe8f9}, {0x97c6,0xe8fa}, {0x97c7,0xe8fb}, {0x97c8,0xe8fc}, {0x97c9,0xe8fd}, {0x97ca,0xe8fe}, {0x97cb,0xe8ff}, {0x97cc,0xe900},
    {0x97cd,0xe901}, {0x97ce,0xe902}, {0x97cf,0xe903}, {0x97d0,0xe904}, {0x97d1,0xe905}, {0x97d2,0xe906}, {0x97d3,0xe907}, {0x97d4,0xe908}, {0x97d5,0xe909}, {0x97d6,0xe90a},
    {0x97d7,0xe90b}, {0x97d8,0xe90c}, {0x97d9,0xe90d}, {0x97da,0xe90e}, {0x97db,0xe90f}, {0x97dc,0xe910}, {0x97dd,0xe911}, {0x97de,0xe912}, {0x97df,0xe913}, {0x97e0,0xe914},
    {0x97e1,0xe915}, {0x97e2,0xe916}, {0x97e3,0xe917}, {0x97e4,0xe918}, {0x97e5,0xe919}, {0x97e6,0xe91a}, {0x97e7,0xe91b}, {0x97e8,0xe91c}, {0x97e9,0xe91d}, {0x97ea,0xe91e},
    {0x97eb,0xe91f}, {0x97ec,0xe920}, {0x97ed,0xe921}, {0x97ee,0xe922}, {0x97ef,0xe923}, {0x97f0,0xe924}, {0x97f1,0xe925}, {0x97f2,0xe926}, {0x97f3,0xe927}, {0x97f4,0xe928},
    {0x97f5,0xe929}, {0x97f6,0xe92a}, {0x97f7,0xe92b}, {0x97f8,0xe92c}, {0x97f9,0xe92d}, {0x97fa,0xe92e}, {0x97fb,0xe92f}, {0x97fc,0xe930}, {0x97fd,0xe931}, {0x97fe,0xe932},
    {0x9840,0xe933}, {0x9841,0xe934}, {0x9842,0xe935}, {0x9843,0xe936}, {0x9844,0xe937}, {0x9845,0xe938}, {0x9846,0xe939}, {0x9847,0xe93a}, {0x9848,0xe93b}, {0x9849,0xe93c},
    {0x984a,0xe93d}, {0x984b,0xe93e}, {0x984c,0xe93f}, {0x984d,0xe940}, {0x984e,0xe941}, {0x984f,0xe942}, {0x9850,0xe943}, {0x9851,0xe944}, {0x9852,0xe945}, {0x9853,0xe946},
    {0x9854,0xe947}, {0x9855,0xe948}, {0x9856,0xe949}, {0x9857,0xe94a}, {0x9858,0xe94b}, {0x9859,0xe94c}, {0x985a,0xe94d}, {0x985b,0xe94e}, {0x985c,0xe94f}, {0x985d,0xe950},
    {0x985e,0xe951}, {0x985f,0xe952}, {0x9860,0xe953}, {0x9861,0xe954}, {0x9862,0xe955}, {0x9863,0xe956}, {0x9864,0xe957}, {0x9865,0xe958}, {0x9866,0xe959}, {0x9867,0xe95a},
    {0x9868,0xe95b}, {0x9869,0xe95c}, {0x986a,0xe95d}, {0x986b,0xe95e}, {0x986c,0xe95f}, {0x986d,0xe960}, {0x986e,0xe961}, {0x986f,0xe962}, {0x9870,0xe963}, {0x9871,0xe964},
    {0x9872,0xe965}, {0x9873,0xe966}, {0x9874,0xe967}, {0x9875,0xe968}, {0x9876,0xe969}, {0x9877,0xe96a}, {0x9878,0xe96b}, {0x9879,0xe96c}, {0x987a,0xe96d}, {0x987b,0xe96e},
    {0x987c,0xe96f}, {0x987d,0xe970}, {0x987e,0xe971}, {0x98a1,0xe972}, {0x98a2,0xe973}, {0x98a3,0xe974}, {0x98a4,0xe975}, {0x98a5,0xe976}, {0x98a6,0xe977}, {0x98a7,0xe978},
    {0x98a8,0xe979}, {0x98a9,0xe97a}, {0x98aa,0xe97b}, {0x98ab,0xe97c}, {0x98ac,0xe97d}, {0x98ad,0xe97e}, {0x98ae,0xe97f}, {0x98af,0xe980}, {0x98b0,0xe981}, {0x98b1,0xe982},
    {0x98b2,0xe983}, {0x98b3,0xe984}, {0x98b4,0xe985}, {0x98b5,0xe986}, {0x98b6,0xe987}, {0x98b7,0xe988}, {0x98b8,0xe989}, {0x98b9,0xe98a}, {0x98ba,0xe98b}, {0x98bb,0xe98c},
    {0x98bc,0xe98d}, {0x98bd,0xe98e}, {0x98be,0xe98f}, {0x98bf,0xe990}, {0x98c0,0xe991}, {0x98c1,0xe992}, {0x98c2,0xe993}, {0x98c3,0xe994}, {0x98c4,0xe995}, {0x98c5,0xe996},
    {0x98c6,0xe997}, {0x98c7,0xe998}, {0x98c8,0xe999}, {0x98c9,0xe99a}, {0x98ca,0xe99b}, {0x98cb,0xe99c}, {0x98cc,0xe99d}, {0x98cd,0xe99e}, {0x98ce,0xe99f}, {0x98cf,0xe9a0},
    {0x98d0,0xe9a1}, {0x98d1,0xe9a2}, {0x98d2,0xe9a3}, {0x98d3,0xe9a4}, {0x98d4,0xe9a5}, {0x98d5,0xe9a6}, {0x98d6,0xe9a7}, {0x98d7,0xe9a8}, {0x98d8,0xe9a9}, {0x98d9,0xe9aa},
    {0x98da,0xe9ab}, {0x98db,0xe9ac}, {0x98dc,0xe9ad}, {0x98dd,0xe9ae}, {0x98de,0xe9af}, {0x98df,0xe9b0}, {0x98e0,0xe9b1}, {0x98e1,0xe9b2}, {0x98e2,0xe9b3}, {0x98e3,0xe9b4},
    {0x98e4,0xe9b5}, {0x98e5,0xe9b6}, {0x98e6,0xe9b7}, {0x98e7,0xe9b8}, {0x98e8,0xe9b9}, {0x98e9,0xe9ba}, {0x98ea,0xe9bb}, {0x98eb,0xe9bc}, {0x98ec,0xe9bd}, {0x98ed,0xe9be},
    {0x98ee,0xe9bf}, {0x98ef,0xe9c0}, {0x98f0,0xe9c1}, {0x98f1,0xe9c2}, {0x98f2,0xe9c3}, {0x98f3,0xe9c4}, {0x98f4,0xe9c5}, {0x98f5,0xe9c6}, {0x98f6,0xe9c7}, {0x98f7,0xe9c8},
    {0x98f8,0xe9c9}, {0x98f9,0xe9ca}, {0x98fa,0xe9cb}, {0x98fb,0xe9cc}, {0x98fc,0xe9cd}, {0x98fd,0xe9ce}, {0x98fe,0xe9cf}, {0x9940,0xe9d0}, {0x9941,0xe9d1}, {0x9942,0xe9d2},
    {0x9943,0xe9d3}, {0x9944,0xe9d4}, {0x9945,0xe9d5}, {0x9946,0xe9d6}, {0x9947,0xe9d7}, {0x9948,0xe9d8}, {0x9949,0xe9d9}, {0x994a,0xe9da}, {0x994b,0xe9db}, {0x994c,0xe9dc},
    {0x994d,0xe9dd}, {0x994e,0xe9de}, {0x994f,0xe9df}, {0x9950,0xe9e0}, {0x9951,0xe9e1}, {0x9952,0xe9e2}, {0x9953,0xe9e3}, {0x9954,0xe9e4}, {0x9955,0xe9e5}, {0x9956,0xe9e6},
    {0x9957,0xe9e7}, {0x9958,0xe9e8}, {0x9959,0xe9e9}, {0x995a,0xe9ea}, {0x995b,0xe9eb}, {0x995c,0xe9ec}, {0x995d,0xe9ed}, {0x995e,0xe9ee}, {0x995f,0xe9ef}, {0x9960,0xe9f0},
    {0x9961,0xe9f1}, {0x9962,0xe9f2}, {0x9963,0xe9f3}, {0x9964,0xe9f4}, {0x9965,0xe9f5}, {0x9966,0xe9f6}, {0x9967,0xe9f7}, {0x9968,0xe9f8}, {0x9969,0xe9f9}, {0x996a,0xe9fa},
    {0x996b,0xe9fb}, {0x996c,0xe9fc}, {0x996d,0xe9fd}, {0x996e,0xe9fe}, {0x996f,0xe9ff}, {0x9970,0xea00}, {0x9971,0xea01}, {0x9972,0xea02}, {0x9973,0xea03}, {0x9974,0xea04},
    {0x9975,0xea05}, {0x9976,0xea06}, {0x9977,0xea07}, {0x9978,0xea08}, {0x9979,0xea09}, {0x997a,0xea0a}, {0x997b,0xea0b}, {0x997c,0xea0c}, {0x997d,0xea0d}, {0x997e,0xea0e},
    {0x99a1,0xea0f}, {0x99a2,0xea10}, {0x99a3,0xea11}, {0x99a4,0xea12}, {0x99a5,0xea13}, {0x99a6,0xea14}, {0x99a7,0xea15}, {0x99a8,0xea16}, {0x99a9,0xea17}, {0x99aa,0xea18},
    {0x99ab,0xea19}, {0x99ac,0xea1a}, {0x99ad,0xea1b}, {0x99ae,0xea1c}, {0x99af,0xea1d}, {0x99b0,0xea1e}, {0x99b1,0xea1f}, {0x99b2,0xea20}, {0x99b3,0xea21}, {0x99b4,0xea22},
    {0x99b5,0xea23}, {0x99b6,0xea24}, {0x99b7,0xea25}, {0x99b8,0xea26}, {0x99b9,0xea27}, {0x99ba,0xea28}, {0x99bb,0xea29}, {0x99bc,0xea2a}, {0x99bd,0xea2b}, {0x99be,0xea2c},
    {0x99bf,0xea2d}, {0x99c0,0xea2e}, {0x99c1,0xea2f}, {0x99c2,0xea30}, {0x99c3,0xea31}, {0x99c4,0xea32}, {0x99c5,0xea33}, {0x99c6,0xea34}, {0x99c7,0xea35}, {0x99c8,0xea36},
    {0x99c9,0xea37}, {0x99ca,0xea38}, {0x99cb,0xea39}, {0x99cc,0xea3a}, {0x99cd,0xea3b}, {0x99ce,0xea3c}, {0x99cf,0xea3d}, {0x99d0,0xea3e}, {0x99d1,0xea3f}, {0x99d2,0xea40},
    {0x99d3,0xea41}, {0x99d4,0xea42}, {0x99d5,0xea43}, {0x99d6,0xea44}, {0x99d7,0xea45}, {0x99d8,0xea46}, {0x99d9,0xea47}, {0x99da,0xea48}, {0x99db,0xea49}, {0x99dc,0xea4a},
    {0x99dd,0xea4b}, {0x99de,0xea4c}, {0x99df,0xea4d}, {0x99e0,0xea4e}, {0x99e1,0xea4f}, {0x99e2,0xea50}, {0x99e3,0xea51}, {0x99e4,0xea52}, {0x99e5,0xea53}, {0x99e6,0xea54},
    {0x99e7,0xea55}, {0x99e8,0xea56}, {0x99e9,0xea57}, {0x99ea,0xea58}, {0x99eb,0xea59}, {0x99ec,0xea5a}, {0x99ed,0xea5b}, {0x99ee,0xea5c}, {0x99ef,0xea5d}, {0x99f0,0xea5e},
    {0x99f1,0xea5f}, {0x99f2,0xea60}, {0x99f3,0xea61}, {0x99f4,0xea62}, {0x99f5,0xea63}, {0x99f6,0xea64}, {0x99f7,0xea65}, {0x99f8,0xea66}, {0x99f9,0xea67}, {0x99fa,0xea68},
    {0x99fb,0xea69}, {0x99fc,0xea6a}, {0x99fd,0xea6b}, {0x99fe,0xea6c}, {0x9a40,0xea6d}, {0x9a41,0xea6e}, {0x9a42,0xea6f}, {0x9a43,0xea70}, {0x9a44,0xea71}, {0x9a45,0xea72},
    {0x9a46,0xea73}, {0x9a47,0xea74}, {0x9a48,0xea75}, {0x9a49,0xea76}, {0x9a4a,0xea77}, {0x9a4b,0xea78}, {0x9a4c,0xea79}, {0x9a4d,0xea7a}, {0x9a4e,0xea7b}, {0x9a4f,0xea7c},
    {0x9a50,0xea7d}, {0x9a51,0xea7e}, {0x9a52,0xea7f}, {0x9a53,0xea80}, {0x9a54,0xea81}, {0x9a55,0xea82}, {0x9a56,0xea83}, {0x9a57,0xea84}, {0x9a58,0xea85}, {0x9a59,0xea86},
    {0x9a5a,0xea87}, {0x9a5b,0xea88}, {0x9a5c,0xea89}, {0x9a5d,0xea8a}, {0x9a5e,0xea8b}, {0x9a5f,0xea8c}, {0x9a60,0xea8d}, {0x9a61,0xea8e}, {0x9a62,0xea8f}, {0x9a63,0xea90},
    {0x9a64,0xea91}, {0x9a65,0xea92}, {0x9a66,0xea93}, {0x9a67,0xea94}, {0x9a68,0xea95}, {0x9a69,0xea96}, {0x9a6a,0xea97}, {0x9a6b,0xea98}, {0x9a6c,0xea99}, {0x9a6d,0xea9a},
    {0x9a6e,0xea9b}, {0x9a6f,0xea9c}, {0x9a70,0xea9d}, {0x9a71,0xea9e}, {0x9a72,0xea9f}, {0x9a73,0xeaa0}, {0x9a74,0xeaa1}, {0x9a75,0xeaa2}, {0x9a76,0xeaa3}, {0x9a77,0xeaa4},
    {0x9a78,0xeaa5}, {0x9a79,0xeaa6}, {0x9a7a,0xeaa7}, {0x9a7b,0xeaa8}, {0x9a7c,0xeaa9}, {0x9a7d,0xeaaa}, {0x9a7e,0xeaab}, {0x9aa1,0xeaac}, {0x9aa2,0xeaad}, {0x9aa3,0xeaae},
    {0x9aa4,0xeaaf}, {0x9aa5,0xeab0}, {0x9aa6,0xeab1}, {0x9aa7,0xeab2}, {0x9aa8,0xeab3}, {0x9aa9,0xeab4}, {0x9aaa,0xeab5}, {0x9aab,0xeab6}, {0x9aac,0xeab7}, {0x9aad,0xeab8},
    {0x9aae,0xeab9}, {0x9aaf,0xeaba}, {0x9ab0,0xeabb}, {0x9ab1,0xeabc}, {0x9ab2,0xeabd}, {0x9ab3,0xeabe}, {0x9ab4,0xeabf}, {0x9ab5,0xeac0}, {0x9ab6,0xeac1}, {0x9ab7,0xeac2},
    {0x9ab8,0xeac3}, {0x9ab9,0xeac4}, {0x9aba,0xeac5}, {0x9abb,0xeac6}, {0x9abc,0xeac7}, {0x9abd,0xeac8}, {0x9abe,0xeac9}, {0x9abf,0xeaca}, {0x9ac0,0xeacb}, {0x9ac1,0xeacc},
    {0x9ac2,0xeacd}, {0x9ac3,0xeace}, {0x9ac4,0xeacf}, {0x9ac5,0xead0}, {0x9ac6,0xead1}, {0x9ac7,0xead2}, {0x9ac8,0xead3}, {0x9ac9,0xead4}, {0x9aca,0xead5}, {0x9acb,0xead6},
    {0x9acc,0xead7}, {0x9acd,0xead8}, {0x9ace,0xead9}, {0x9acf,0xeada}, {0x9ad0,0xeadb}, {0x9ad1,0xeadc}, {0x9ad2,0xeadd}, {0x9ad3,0xeade}, {0x9ad4,0xeadf}, {0x9ad5,0xeae0},
    {0x9ad6,0xeae1}, {0x9ad7,0xeae2}, {0x9ad8,0xeae3}, {0x9ad9,0xeae4}, {0x9ada,0xeae5}, {0x9adb,0xeae6}, {0x9adc,0xeae7}, {0x9add,0xeae8}, {0x9ade,0xeae9}, {0x9adf,0xeaea},
    {0x9ae0,0xeaeb}, {0x9ae1,0xeaec}, {0x9ae2,0xeaed}, {0x9ae3,0xeaee}, {0x9ae4,0xeaef}, {0x9ae5,0xeaf0}, {0x9ae6,0xeaf1}, {0x9ae7,0xeaf2}, {0x9ae8,0xeaf3}, {0x9ae9,0xeaf4},
    {0x9aea,0xeaf5}, {0x9aeb,0xeaf6}, {0x9aec,0xeaf7}, {0x9aed,0xeaf8}, {0x9aee,0xeaf9}, {0x9aef,0xeafa}, {0x9af0,0xeafb}, {0x9af1,0xeafc}, {0x9af2,0xeafd}, {0x9af3,0xeafe},
    {0x9af4,0xeaff}, {0x9af5,0xeb00}, {0x9af6,0xeb01}, {0x9af7,0xeb02}, {0x9af8,0xeb03}, {0x9af9,0xeb04}, {0x9afa,0xeb05}, {0x9afb,0xeb06}, {0x9afc,0xeb07}, {0x9afd,0xeb08},
    {0x9afe,0xeb09}, {0x9b40,0xeb0a}, {0x9b41,0xeb0b}, {0x9b42,0xeb0c}, {0x9b43,0xeb0d}, {0x9b44,0xeb0e}, {0x9b45,0xeb0f}, {0x9b46,0xeb10}, {0x9b47,0xeb11}, {0x9b48,0xeb12},
    {0x9b49,0xeb13}, {0x9b4a,0xeb14}, {0x9b4b,0xeb15}, {0x9b4c,0xeb16}, {0x9b4d,0xeb17}, {0x9b4e,0xeb18}, {0x9b4f,0xeb19}, {0x9b50,0xeb1a}, {0x9b51,0xeb1b}, {0x9b52,0xeb1c},
    {0x9b53,0xeb1d}, {0x9b54,0xeb1e}, {0x9b55,0xeb1f}, {0x9b56,0xeb20}, {0x9b57,0xeb21}, {0x9b58,0xeb22}, {0x9b59,0xeb23}, {0x9b5a,0xeb24}, {0x9b5b,0xeb25}, {0x9b5c,0xeb26},
    {0x9b5d,0xeb27}, {0x9b5e,0xeb28}, {0x9b5f,0xeb29}, {0x9b60,0xeb2a}, {0x9b61,0xeb2b}, {0x9b62,0xeb2c}, {0x9b63,0xeb2d}, {0x9b64,0xeb2e}, {0x9b65,0xeb2f}, {0x9b66,0xeb30},
    {0x9b67,0xeb31}, {0x9b68,0xeb32}, {0x9b69,0xeb33}, {0x9b6a,0xeb34}, {0x9b6b,0xeb35}, {0x9b6c,0xeb36}, {0x9b6d,0xeb37}, {0x9b6e,0xeb38}, {0x9b6f,0xeb39}, {0x9b70,0xeb3a},
    {0x9b71,0xeb3b}, {0x9b72,0xeb3c}, {0x9b73,0xeb3d}, {0x9b74,0xeb3e}, {0x9b75,0xeb3f}, {0x9b76,0xeb40}, {0x9b77,0xeb41}, {0x9b78,0xeb42}, {0x9b79,0xeb43}, {0x9b7a,0xeb44},
    {0x9b7b,0xeb45}, {0x9b7c,0xeb46}, {0x9b7d,0xeb47}, {0x9b7e,0xeb48}, {0x9ba1,0xeb49}, {0x9ba2,0xeb4a}, {0x9ba3,0xeb4b}, {0x9ba4,0xeb4c}, {0x9ba5,0xeb4d}, {0x9ba6,0xeb4e},
    {0x9ba7,0xeb4f}, {0x9ba8,0xeb50}, {0x9ba9,0xeb51}, {0x9baa,0xeb52}, {0x9bab,0xeb53}, {0x9bac,0xeb54}, {0x9bad,0xeb55}, {0x9bae,0xeb56}, {0x9baf,0xeb57}, {0x9bb0,0xeb58},
    {0x9bb1,0xeb59}, {0x9bb2,0xeb5a}, {0x9bb3,0xeb5b}, {0x9bb4,0xeb5c}, {0x9bb5,0xeb5d}, {0x9bb6,0xeb5e}, {0x9bb7,0xeb5f}, {0x9bb8,0xeb60}, {0x9bb9,0xeb61}, {0x9bba,0xeb62},
    {0x9bbb,0xeb63}, {0x9bbc,0xeb64}, {0x9bbd,0xeb65}, {0x9bbe,0xeb66}, {0x9bbf,0xeb67}, {0x9bc0,0xeb68}, {0x9bc1,0xeb69}, {0x9bc2,0xeb6a}, {0x9bc3,0xeb6b}, {0x9bc4,0xeb6c},
    {0x9bc5,0xeb6d}, {0x9bc6,0xeb6e}, {0x9bc7,0xeb6f}, {0x9bc8,0xeb70}, {0x9bc9,0xeb71}, {0x9bca,0xeb72}, {0x9bcb,0xeb73}, {0x9bcc,0xeb74}, {0x9bcd,0xeb75}, {0x9bce,0xeb76},
    {0x9bcf,0xeb77}, {0x9bd0,0xeb78}, {0x9bd1,0xeb79}, {0x9bd2,0xeb7a}, {0x9bd3,0xeb7b}, {0x9bd4,0xeb7c}, {0x9bd5,0xeb7d}, {0x9bd6,0xeb7e}, {0x9bd7,0xeb7f}, {0x9bd8,0xeb80},
    {0x9bd9,0xeb81}, {0x9bda,0xeb82}, {0x9bdb,0xeb83}, {0x9bdc,0xeb84}, {0x9bdd,0xeb85}, {0x9bde,0xeb86}, {0x9bdf,0xeb87}, {0x9be0,0xeb88}, {0x9be1,0xeb89}, {0x9be2,0xeb8a},
    {0x9be3,0xeb8b}, {0x9be4,0xeb8c}, {0x9be5,0xeb8d}, {0x9be6,0xeb8e}, {0x9be7,0xeb8f}, {0x9be8,0xeb90}, {0x9be9,0xeb91}, {0x9bea,0xeb92}, {0x9beb,0xeb93}, {0x9bec,0xeb94},
    {0x9bed,0xeb95}, {0x9bee,0xeb96}, {0x9bef,0xeb97}, {0x9bf0,0xeb98}, {0x9bf1,0xeb99}, {0x9bf2,0xeb9a}, {0x9bf3,0xeb9b}, {0x9bf4,0xeb9c}, {0x9bf5,0xeb9d}, {0x9bf6,0xeb9e},
    {0x9bf7,0xeb9f}, {0x9bf8,0xeba0}, {0x9bf9,0xeba1}, {0x9bfa,0xeba2}, {0x9bfb,0xeba3}, {0x9bfc,0xeba4}, {0x9bfd,0xeba5}, {0x9bfe,0xeba6}, {0x9c40,0xeba7}, {0x9c41,0xeba8},
    {0x9c42,0xeba9}, {0x9c43,0xebaa}, {0x9c44,0xebab}, {0x9c45,0xebac}, {0x9c46,0xebad}, {0x9c47,0xebae}, {0x9c48,0xebaf}, {0x9c49,0xebb0}, {0x9c4a,0xebb1}, {0x9c4b,0xebb2},
    {0x9c4c,0xebb3}, {0x9c4d,0xebb4}, {0x9c4e,0xebb5}, {0x9c4f,0xebb6}, {0x9c50,0xebb7}, {0x9c51,0xebb8}, {0x9c52,0xebb9}, {0x9c53,0xebba}, {0x9c54,0xebbb}, {0x9c55,0xebbc},
    {0x9c56,0xebbd}, {0x9c57,0xebbe}, {0x9c58,0xebbf}, {0x9c59,0xebc0}, {0x9c5a,0xebc1}, {0x9c5b,0xebc2}, {0x9c5c,0xebc3}, {0x9c5d,0xebc4}, {0x9c5e,0xebc5}, {0x9c5f,0xebc6},
    {0x9c60,0xebc7}, {0x9c61,0xebc8}, {0x9c62,0xebc9}, {0x9c63,0xebca}, {0x9c64,0xebcb}, {0x9c65,0xebcc}, {0x9c66,0xebcd}, {0x9c67,0xebce}, {0x9c68,0xebcf}, {0x9c69,0xebd0},
    {0x9c6a,0xebd1}, {0x9c6b,0xebd2}, {0x9c6c,0xebd3}, {0x9c6d,0xebd4}, {0x9c6e,0xebd5}, {0x9c6f,0xebd6}, {0x9c70,0xebd7}, {0x9c71,0xebd8}, {0x9c72,0xebd9}, {0x9c73,0xebda},
    {0x9c74,0xebdb}, {0x9c75,0xebdc}, {0x9c76,0xebdd}, {0x9c77,0xebde}, {0x9c78,0xebdf}, {0x9c79,0xebe0}, {0x9c7a,0xebe1}, {0x9c7b,0xebe2}, {0x9c7c,0xebe3}, {0x9c7d,0xebe4},
    {0x9c7e,0xebe5}, {0x9ca1,0xebe6}, {0x9ca2,0xebe7}, {0x9ca3,0xebe8}, {0x9ca4,0xebe9}, {0x9ca5,0xebea}, {0x9ca6,0xebeb}, {0x9ca7,0xebec}, {0x9ca8,0xebed}, {0x9ca9,0xebee},
    {0x9caa,0xebef}, {0x9cab,0xebf0}, {0x9cac,0xebf1}, {0x9cad,0xebf2}, {0x9cae,0xebf3}, {0x9caf,0xebf4}, {0x9cb0,0xebf5}, {0x9cb1,0xebf6}, {0x9cb2,0xebf7}, {0x9cb3,0xebf8},
    {0x9cb4,0xebf9}, {0x9cb5,0xebfa}, {0x9cb6,0xebfb}, {0x9cb7,0xebfc}, {0x9cb8,0xebfd}, {0x9cb9,0xebfe}, {0x9cba,0xebff}, {0x9cbb,0xec00}, {0x9cbc,0xec01}, {0x9cbd,0xec02},
    {0x9cbe,0xec03}, {0x9cbf,0xec04}, {0x9cc0,0xec05}, {0x9cc1,0xec06}, {0x9cc2,0xec07}, {0x9cc3,0xec08}, {0x9cc4,0xec09}, {0x9cc5,0xec0a}, {0x9cc6,0xec0b}, {0x9cc7,0xec0c},
    {0x9cc8,0xec0d}, {0x9cc9,0xec0e}, {0x9cca,0xec0f}, {0x9ccb,0xec10}, {0x9ccc,0xec11}, {0x9ccd,0xec12}, {0x9cce,0xec13}, {0x9ccf,0xec14}, {0x9cd0,0xec15}, {0x9cd1,0xec16},
    {0x9cd2,0xec17}, {0x9cd3,0xec18}, {0x9cd4,0xec19}, {0x9cd5,0xec1a}, {0x9cd6,0xec1b}, {0x9cd7,0xec1c}, {0x9cd8,0xec1d}, {0x9cd9,0xec1e}, {0x9cda,0xec1f}, {0x9cdb,0xec20},
    {0x9cdc,0xec21}, {0x9cdd,0xec22}, {0x9cde,0xec23}, {0x9cdf,0xec24}, {0x9ce0,0xec25}, {0x9ce1,0xec26}, {0x9ce2,0xec27}, {0x9ce3,0xec28}, {0x9ce4,0xec29}, {0x9ce5,0xec2a},
    {0x9ce6,0xec2b}, {0x9ce7,0xec2c}, {0x9ce8,0xec2d}, {0x9ce9,0xec2e}, {0x9cea,0xec2f}, {0x9ceb,0xec30}, {0x9cec,0xec31}, {0x9ced,0xec32}, {0x9cee,0xec33}, {0x9cef,0xec34},
    {0x9cf0,0xec35}, {0x9cf1,0xec36}, {0x9cf2,0xec37}, {0x9cf3,0xec38}, {0x9cf4,0xec39}, {0x9cf5,0xec3a}, {0x9cf6,0xec3b}, {0x9cf7,0xec3c}, {0x9cf8,0xec3d}, {0x9cf9,0xec3e},
    {0x9cfa,0xec3f}, {0x9cfb,0xec40}, {0x9cfc,0xec41}, {0x9cfd,0xec42}, {0x9cfe,0xec43}, {0x9d40,0xec44}, {0x9d41,0xec45}, {0x9d42,0xec46}, {0x9d43,0xec47}, {0x9d44,0xec48},
    {0x9d45,0xec49}, {0x9d46,0xec4a}, {0x9d47,0xec4b}, {0x9d48,0xec4c}, {0x9d49,0xec4d}, {0x9d4a,0xec4e}, {0x9d4b,0xec4f}, {0x9d4c,0xec50}, {0x9d4d,0xec51}, {0x9d4e,0xec52},
    {0x9d4f,0xec53}, {0x9d50,0xec54}, {0x9d51,0xec55}, {0x9d52,0xec56}, {0x9d53,0xec57}, {0x9d54,0xec58}, {0x9d55,0xec59}, {0x9d56,0xec5a}, {0x9d57,0xec5b}, {0x9d58,0xec5c},
    {0x9d59,0xec5d}, {0x9d5a,0xec5e}, {0x9d5b,0xec5f}, {0x9d5c,0xec60}, {0x9d5d,0xec61}, {0x9d5e,0xec62}, {0x9d5f,0xec63}, {0x9d60,0xec64}, {0x9d61,0xec65}, {0x9d62,0xec66},
    {0x9d63,0xec67}, {0x9d64,0xec68}, {0x9d65,0xec69}, {0x9d66,0xec6a}, {0x9d67,0xec6b}, {0x9d68,0xec6c}, {0x9d69,0xec6d}, {0x9d6a,0xec6e}, {0x9d6b,0xec6f}, {0x9d6c,0xec70},
    {0x9d6d,0xec71}, {0x9d6e,0xec72}, {0x9d6f,0xec73}, {0x9d70,0xec74}, {0x9d71,0xec75}, {0x9d72,0xec76}, {0x9d73,0xec77}, {0x9d74,0xec78}, {0x9d75,0xec79}, {0x9d76,0xec7a},
    {0x9d77,0xec7b}, {0x9d78,0xec7c}, {0x9d79,0xec7d}, {0x9d7a,0xec7e}, {0x9d7b,0xec7f}, {0x9d7c,0xec80}, {0x9d7d,0xec81}, {0x9d7e,0xec82}, {0x9da1,0xec83}, {0x9da2,0xec84},
    {0x9da3,0xec85}, {0x9da4,0xec86}, {0x9da5,0xec87}, {0x9da6,0xec88}, {0x9da7,0xec89}, {0x9da8,0xec8a}, {0x9da9,0xec8b}, {0x9daa,0xec8c}, {0x9dab,0xec8d}, {0x9dac,0xec8e},
    {0x9dad,0xec8f}, {0x9dae,0xec90}, {0x9daf,0xec91}, {0x9db0,0xec92}, {0x9db1,0xec93}, {0x9db2,0xec94}, {0x9db3,0xec95}, {0x9db4,0xec96}, {0x9db5,0xec97}, {0x9db6,0xec98},
    {0x9db7,0xec99}, {0x9db8,0xec9a}, {0x9db9,0xec9b}, {0x9dba,0xec9c}, {0x9dbb,0xec9d}, {0x9dbc,0xec9e}, {0x9dbd,0xec9f}, {0x9dbe,0xeca0}, {0x9dbf,0xeca1}, {0x9dc0,0xeca2},
    {0x9dc1,0xeca3}, {0x9dc2,0xeca4}, {0x9dc3,0xeca5}, {0x9dc4,0xeca6}, {0x9dc5,0xeca7}, {0x9dc6,0xeca8}, {0x9dc7,0xeca9}, {0x9dc8,0xecaa}, {0x9dc9,0xecab}, {0x9dca,0xecac},
    {0x9dcb,0xecad}, {0x9dcc,0xecae}, {0x9dcd,0xecaf}, {0x9dce,0xecb0}, {0x9dcf,0xecb1}, {0x9dd0,0xecb2}, {0x9dd1,0xecb3}, {0x9dd2,0xecb4}, {0x9dd3,0xecb5}, {0x9dd4,0xecb6},
    {0x9dd5,0xecb7}, {0x9dd6,0xecb8}, {0x9dd7,0xecb9}, {0x9dd8,0xecba}, {0x9dd9,0xecbb}, {0x9dda,0xecbc}, {0x9ddb,0xecbd}, {0x9ddc,0xecbe}, {0x9ddd,0xecbf}, {0x9dde,0xecc0},
    {0x9ddf,0xecc1}, {0x9de0,0xecc2}, {0x9de1,0xecc3}, {0x9de2,0xecc4}, {0x9de3,0xecc5}, {0x9de4,0xecc6}, {0x9de5,0xecc7}, {0x9de6,0xecc8}, {0x9de7,0xecc9}, {0x9de8,0xecca},
    {0x9de9,0xeccb}, {0x9dea,0xeccc}, {0x9deb,0xeccd}, {0x9dec,0xecce}, {0x9ded,0xeccf}, {0x9dee,0xecd0}, {0x9def,0xecd1}, {0x9df0,0xecd2}, {0x9df1,0xecd3}, {0x9df2,0xecd4},
    {0x9df3,0xecd5}, {0x9df4,0xecd6}, {0x9df5,0xecd7}, {0x9df6,0xecd8}, {0x9df7,0xecd9}, {0x9df8,0xecda}, {0x9df9,0xecdb}, {0x9dfa,0xecdc}, {0x9dfb,0xecdd}, {0x9dfc,0xecde},
    {0x9dfd,0xecdf}, {0x9dfe,0xece0}, {0x9e40,0xece1}, {0x9e41,0xece2}, {0x9e42,0xece3}, {0x9e43,0xece4}, {0x9e44,0xece5}, {0x9e45,0xece6}, {0x9e46,0xece7}, {0x9e47,0xece8},
    {0x9e48,0xece9}, {0x9e49,0xecea}, {0x9e4a,0xeceb}, {0x9e4b,0xecec}, {0x9e4c,0xeced}, {0x9e4d,0xecee}, {0x9e4e,0xecef}, {0x9e4f,0xecf0}, {0x9e50,0xecf1}, {0x9e51,0xecf2},
    {0x9e52,0xecf3}, {0x9e53,0xecf4}, {0x9e54,0xecf5}, {0x9e55,0xecf6}, {0x9e56,0xecf7}, {0x9e57,0xecf8}, {0x9e58,0xecf9}, {0x9e59,0xecfa}, {0x9e5a,0xecfb}, {0x9e5b,0xecfc},
    {0x9e5c,0xecfd}, {0x9e5d,0xecfe}, {0x9e5e,0xecff}, {0x9e5f,0xed00}, {0x9e60,0xed01}, {0x9e61,0xed02}, {0x9e62,0xed03}, {0x9e63,0xed04}, {0x9e64,0xed05}, {0x9e65,0xed06},
    {0x9e66,0xed07}, {0x9e67,0xed08}, {0x9e68,0xed09}, {0x9e69,0xed0a}, {0x9e6a,0xed0b}, {0x9e6b,0xed0c}, {0x9e6c,0xed0d}, {0x9e6d,0xed0e}, {0x9e6e,0xed0f}, {0x9e6f,0xed10},
    {0x9e70,0xed11}, {0x9e71,0xed12}, {0x9e72,0xed13}, {0x9e73,0xed14}, {0x9e74,0xed15}, {0x9e75,0xed16}, {0x9e76,0xed17}, {0x9e77,0xed18}, {0x9e78,0xed19}, {0x9e79,0xed1a},
    {0x9e7a,0xed1b}, {0x9e7b,0xed1c}, {0x9e7c,0xed1d}, {0x9e7d,0xed1e}, {0x9e7e,0xed1f}, {0x9ea1,0xed20}, {0x9ea2,0xed21}, {0x9ea3,0xed22}, {0x9ea4,0xed23}, {0x9ea5,0xed24},
    {0x9ea6,0xed25}, {0x9ea7,0xed26}, {0x9ea8,0xed27}, {0x9ea9,0xed28}, {0x9eaa,0xed29}, {0x9eab,0xed2a}, {0x9eac,0xed2b}, {0x9ead,0xed2c}, {0x9eae,0xed2d}, {0x9eaf,0xed2e},
    {0x9eb0,0xed2f}, {0x9eb1,0xed30}, {0x9eb2,0xed31}, {0x9eb3,0xed32}, {0x9eb4,0xed33}, {0x9eb5,0xed34}, {0x9eb6,0xed35}, {0x9eb7,0xed36}, {0x9eb8,0xed37}, {0x9eb9,0xed38},
    {0x9eba,0xed39}, {0x9ebb,0xed3a}, {0x9ebc,0xed3b}, {0x9ebd,0xed3c}, {0x9ebe,0xed3d}, {0x9ebf,0xed3e}, {0x9ec0,0xed3f}, {0x9ec1,0xed40}, {0x9ec2,0xed41}, {0x9ec3,0xed42},
    {0x9ec4,0xed43}, {0x9ec5,0xed44}, {0x9ec6,0xed45}, {0x9ec7,0xed46}, {0x9ec8,0xed47}, {0x9ec9,0xed48}, {0x9eca,0xed49}, {0x9ecb,0xed4a}, {0x9ecc,0xed4b}, {0x9ecd,0xed4c},
    {0x9ece,0xed4d}, {0x9ecf,0xed4e}, {0x9ed0,0xed4f}, {0x9ed1,0xed50}, {0x9ed2,0xed51}, {0x9ed3,0xed52}, {0x9ed4,0xed53}, {0x9ed5,0xed54}, {0x9ed6,0xed55}, {0x9ed7,0xed56},
    {0x9ed8,0xed57}, {0x9ed9,0xed58}, {0x9eda,0xed59}, {0x9edb,0xed5a}, {0x9edc,0xed5b}, {0x9edd,0xed5c}, {0x9ede,0xed5d}, {0x9edf,0xed5e}, {0x9ee0,0xed5f}, {0x9ee1,0xed60},
    {0x9ee2,0xed61}, {0x9ee3,0xed62}, {0x9ee4,0xed63}, {0x9ee5,0xed64}, {0x9ee6,0xed65}, {0x9ee7,0xed66}, {0x9ee8,0xed67}, {0x9ee9,0xed68}, {0x9eea,0xed69}, {0x9eeb,0xed6a},
    {0x9eec,0xed6b}, {0x9eed,0xed6c}, {0x9eee,0xed6d}, {0x9eef,0xed6e}, {0x9ef0,0xed6f}, {0x9ef1,0xed70}, {0x9ef2,0xed71}, {0x9ef3,0xed72}, {0x9ef4,0xed73}, {0x9ef5,0xed74},
    {0x9ef6,0xed75}, {0x9ef7,0xed76}, {0x9ef8,0xed77}, {0x9ef9,0xed78}, {0x9efa,0xed79}, {0x9efb,0xed7a}, {0x9efc,0xed7b}, {0x9efd,0xed7c}, {0x9efe,0xed7d}, {0x9f40,0xed7e},
    {0x9f41,0xed7f}, {0x9f42,0xed80}, {0x9f43,0xed81}, {0x9f44,0xed82}, {0x9f45,0xed83}, {0x9f46,0xed84}, {0x9f47,0xed85}, {0x9f48,0xed86}, {0x9f49,0xed87}, {0x9f4a,0xed88},
    {0x9f4b,0xed89}, {0x9f4c,0xed8a}, {0x9f4d,0xed8b}, {0x9f4e,0xed8c}, {0x9f4f,0xed8d}, {0x9f50,0xed8e}, {0x9f51,0xed8f}, {0x9f52,0xed90}, {0x9f53,0xed91}, {0x9f54,0xed92},
    {0x9f55,0xed93}, {0x9f56,0xed94}, {0x9f57,0xed95}, {0x9f58,0xed96}, {0x9f59,0xed97}, {0x9f5a,0xed98}, {0x9f5b,0xed99}, {0x9f5c,0xed9a}, {0x9f5d,0xed9b}, {0x9f5e,0xed9c},
    {0x9f5f,0xed9d}, {0x9f60,0xed9e}, {0x9f61,0xed9f}, {0x9f62,0xeda0}, {0x9f63,0xeda1}, {0x9f64,0xeda2}, {0x9f65,0xeda3}, {0x9f66,0xeda4}, {0x9f67,0xeda5}, {0x9f68,0xeda6},
    {0x9f69,0xeda7}, {0x9f6a,0xeda8}, {0x9f6b,0xeda9}, {0x9f6c,0xedaa}, {0x9f6d,0xedab}, {0x9f6e,0xedac}, {0x9f6f,0xedad}, {0x9f70,0xedae}, {0x9f71,0xedaf}, {0x9f72,0xedb0},
    {0x9f73,0xedb1}, {0x9f74,0xedb2}, {0x9f75,0xedb3}, {0x9f76,0xedb4}, {0x9f77,0xedb5}, {0x9f78,0xedb6}, {0x9f79,0xedb7}, {0x9f7a,0xedb8}, {0x9f7b,0xedb9}, {0x9f7c,0xedba},
    {0x9f7d,0xedbb}, {0x9f7e,0xedbc}, {0x9fa1,0xedbd}, {0x9fa2,0xedbe}, {0x9fa3,0xedbf}, {0x9fa4,0xedc0}, {0x9fa5,0xedc1}, {0x9fa6,0xedc2}, {0x9fa7,0xedc3}, {0x9fa8,0xedc4},
    {0x9fa9,0xedc5}, {0x9faa,0xedc6}, {0x9fab,0xedc7}, {0x9fac,0xedc8}, {0x9fad,0xedc9}, {0x9fae,0xedca}, {0x9faf,0xedcb}, {0x9fb0,0xedcc}, {0x9fb1,0xedcd}, {0x9fb2,0xedce},
    {0x9fb3,0xedcf}, {0x9fb4,0xedd0}, {0x9fb5,0xedd1}, {0x9fb6,0xedd2}, {0x9fb7,0xedd3}, {0x9fb8,0xedd4}, {0x9fb9,0xedd5}, {0x9fba,0xedd6}, {0x9fbb,0xedd7}, {0x9fbc,0xedd8},
    {0x9fbd,0xedd9}, {0x9fbe,0xedda}, {0x9fbf,0xeddb}, {0x9fc0,0xeddc}, {0x9fc1,0xeddd}, {0x9fc2,0xedde}, {0x9fc3,0xeddf}, {0x9fc4,0xede0}, {0x9fc5,0xede1}, {0x9fc6,0xede2},
    {0x9fc7,0xede3}, {0x9fc8,0xede4}, {0x9fc9,0xede5}, {0x9fca,0xede6}, {0x9fcb,0xede7}, {0x9fcc,0xede8}, {0x9fcd,0xede9}, {0x9fce,0xedea}, {0x9fcf,0xedeb}, {0x9fd0,0xedec},
    {0x9fd1,0xeded}, {0x9fd2,0xedee}, {0x9fd3,0xedef}, {0x9fd4,0xedf0}, {0x9fd5,0xedf1}, {0x9fd6,0xedf2}, {0x9fd7,0xedf3}, {0x9fd8,0xedf4}, {0x9fd9,0xedf5}, {0x9fda,0xedf6},
    {0x9fdb,0xedf7}, {0x9fdc,0xedf8}, {0x9fdd,0xedf9}, {0x9fde,0xedfa}, {0x9fdf,0xedfb}, {0x9fe0,0xedfc}, {0x9fe1,0xedfd}, {0x9fe2,0xedfe}, {0x9fe3,0xedff}, {0x9fe4,0xee00},
    {0x9fe5,0xee01}, {0x9fe6,0xee02}, {0x9fe7,0xee03}, {0x9fe8,0xee04}, {0x9fe9,0xee05}, {0x9fea,0xee06}, {0x9feb,0xee07}, {0x9fec,0xee08}, {0x9fed,0xee09}, {0x9fee,0xee0a},
    {0x9fef,0xee0b}, {0x9ff0,0xee0c}, {0x9ff1,0xee0d}, {0x9ff2,0xee0e}, {0x9ff3,0xee0f}, {0x9ff4,0xee10}, {0x9ff5,0xee11}, {0x9ff6,0xee12}, {0x9ff7,0xee13}, {0x9ff8,0xee14},
    {0x9ff9,0xee15}, {0x9ffa,0xee16}, {0x9ffb,0xee17}, {0x9ffc,0xee18}, {0x9ffd,0xee19}, {0x9ffe,0xee1a}, {0xa040,0xee1b}, {0xa041,0xee1c}, {0xa042,0xee1d}, {0xa043,0xee1e},
    {0xa044,0xee1f}, {0xa045,0xee20}, {0xa046,0xee21}, {0xa047,0xee22}, {0xa048,0xee23}, {0xa049,0xee24}, {0xa04a,0xee25}, {0xa04b,0xee26}, {0xa04c,0xee27}, {0xa04d,0xee28},
    {0xa04e,0xee29}, {0xa04f,0xee2a}, {0xa050,0xee2b}, {0xa051,0xee2c}, {0xa052,0xee2d}, {0xa053,0xee2e}, {0xa054,0xee2f}, {0xa055,0xee30}, {0xa056,0xee31}, {0xa057,0xee32},
    {0xa058,0xee33}, {0xa059,0xee34}, {0xa05a,0xee35}, {0xa05b,0xee36}, {0xa05c,0xee37}, {0xa05d,0xee38}, {0xa05e,0xee39}, {0xa05f,0xee3a}, {0xa060,0xee3b}, {0xa061,0xee3c},
    {0xa062,0xee3d}, {0xa063,0xee3e}, {0xa064,0xee3f}, {0xa065,0xee40}, {0xa066,0xee41}, {0xa067,0xee42}, {0xa068,0xee43}, {0xa069,0xee44}, {0xa06a,0xee45}, {0xa06b,0xee46},
    {0xa06c,0xee47}, {0xa06d,0xee48}, {0xa06e,0xee49}, {0xa06f,0xee4a}, {0xa070,0xee4b}, {0xa071,0xee4c}, {0xa072,0xee4d}, {0xa073,0xee4e}, {0xa074,0xee4f}, {0xa075,0xee50},
    {0xa076,0xee51}, {0xa077,0xee52}, {0xa078,0xee53}, {0xa079,0xee54}, {0xa07a,0xee55}, {0xa07b,0xee56}, {0xa07c,0xee57}, {0xa07d,0xee58}, {0xa07e,0xee59}, {0xa0a1,0xee5a},
    {0xa0a2,0xee5b}, {0xa0a3,0xee5c}, {0xa0a4,0xee5d}, {0xa0a5,0xee5e}, {0xa0a6,0xee5f}, {0xa0a7,0xee60}, {0xa0a8,0xee61}, {0xa0a9,0xee62}, {0xa0aa,0xee63}, {0xa0ab,0xee64},
    {0xa0ac,0xee65}, {0xa0ad,0xee66}, {0xa0ae,0xee67}, {0xa0af,0xee68}, {0xa0b0,0xee69}, {0xa0b1,0xee6a}, {0xa0b2,0xee6b}, {0xa0b3,0xee6c}, {0xa0b4,0xee6d}, {0xa0b5,0xee6e},
    {0xa0b6,0xee6f}, {0xa0b7,0xee70}, {0xa0b8,0xee71}, {0xa0b9,0xee72}, {0xa0ba,0xee73}, {0xa0bb,0xee74}, {0xa0bc,0xee75}, {0xa0bd,0xee76}, {0xa0be,0xee77}, {0xa0bf,0xee78},
    {0xa0c0,0xee79}, {0xa0c1,0xee7a}, {0xa0c2,0xee7b}, {0xa0c3,0xee7c}, {0xa0c4,0xee7d}, {0xa0c5,0xee7e}, {0xa0c6,0xee7f}, {0xa0c7,0xee80}, {0xa0c8,0xee81}, {0xa0c9,0xee82},
    {0xa0ca,0xee83}, {0xa0cb,0xee84}, {0xa0cc,0xee85}, {0xa0cd,0xee86}, {0xa0ce,0xee87}, {0xa0cf,0xee88}, {0xa0d0,0xee89}, {0xa0d1,0xee8a}, {0xa0d2,0xee8b}, {0xa0d3,0xee8c},
    {0xa0d4,0xee8d}, {0xa0d5,0xee8e}, {0xa0d6,0xee8f}, {0xa0d7,0xee90}, {0xa0d8,0xee91}, {0xa0d9,0xee92}, {0xa0da,0xee93}, {0xa0db,0xee94}, {0xa0dc,0xee95}, {0xa0dd,0xee96},
    {0xa0de,0xee97}, {0xa0df,0xee98}, {0xa0e0,0xee99}, {0xa0e1,0xee9a}, {0xa0e2,0xee9b}, {0xa0e3,0xee9c}, {0xa0e4,0xee9d}, {0xa0e5,0xee9e}, {0xa0e6,0xee9f}, {0xa0e7,0xeea0},
    {0xa0e8,0xeea1}, {0xa0e9,0xeea2}, {0xa0ea,0xeea3}, {0xa0eb,0xeea4}, {0xa0ec,0xeea5}, {0xa0ed,0xeea6}, {0xa0ee,0xeea7}, {0xa0ef,0xeea8}, {0xa0f0,0xeea9}, {0xa0f1,0xeeaa},
    {0xa0f2,0xeeab}, {0xa0f3,0xeeac}, {0xa0f4,0xeead}, {0xa0f5,0xeeae}, {0xa0f6,0xeeaf}, {0xa0f7,0xeeb0}, {0xa0f8,0xeeb1}, {0xa0f9,0xeeb2}, {0xa0fa,0xeeb3}, {0xa0fb,0xeeb4},
    {0xa0fc,0xeeb5}, {0xa0fd,0xeeb6}, {0xa0fe,0xeeb7},
};

static const B5Map b5_C6A1_to_uc_map[408] = {
    {0xc6a1,0xf6b1}, {0xc6a2,0xf6b2}, {0xc6a3,0xf6b3}, {0xc6a4,0xf6b4}, {0xc6a5,0xf6b5}, {0xc6a6,0xf6b6}, {0xc6a7,0xf6b7}, {0xc6a8,0xf6b8}, {0xc6a9,0xf6b9}, {0xc6aa,0xf6ba},
    {0xc6ab,0xf6bb}, {0xc6ac,0xf6bc}, {0xc6ad,0xf6bd}, {0xc6ae,0xf6be}, {0xc6af,0xf6bf}, {0xc6b0,0xf6c0}, {0xc6b1,0xf6c1}, {0xc6b2,0xf6c2}, {0xc6b3,0xf6c3}, {0xc6b4,0xf6c4},
    {0xc6b5,0xf6c5}, {0xc6b6,0xf6c6}, {0xc6b7,0xf6c7}, {0xc6b8,0xf6c8}, {0xc6b9,0xf6c9}, {0xc6ba,0xf6ca}, {0xc6bb,0xf6cb}, {0xc6bc,0xf6cc}, {0xc6bd,0xf6cd}, {0xc6be,0xf6ce},
    {0xc6bf,0xf6cf}, {0xc6c0,0xf6d0}, {0xc6c1,0xf6d1}, {0xc6c2,0xf6d2}, {0xc6c3,0xf6d3}, {0xc6c4,0xf6d4}, {0xc6c5,0xf6d5}, {0xc6c6,0xf6d6}, {0xc6c7,0xf6d7}, {0xc6c8,0xf6d8},
    {0xc6c9,0xf6d9}, {0xc6ca,0xf6da}, {0xc6cb,0xf6db}, {0xc6cc,0xf6dc}, {0xc6cd,0xf6dd}, {0xc6ce,0xf6de}, {0xc6cf,0xf6df}, {0xc6d0,0xf6e0}, {0xc6d1,0xf6e1}, {0xc6d2,0xf6e2},
    {0xc6d3,0xf6e3}, {0xc6d4,0xf6e4}, {0xc6d5,0xf6e5}, {0xc6d6,0xf6e6}, {0xc6d7,0xf6e7}, {0xc6d8,0xf6e8}, {0xc6d9,0xf6e9}, {0xc6da,0xf6ea}, {0xc6db,0xf6eb}, {0xc6dc,0xf6ec},
    {0xc6dd,0xf6ed}, {0xc6de,0xf6ee}, {0xc6df,0xf6ef}, {0xc6e0,0xf6f0}, {0xc6e1,0xf6f1}, {0xc6e2,0xf6f2}, {0xc6e3,0xf6f3}, {0xc6e4,0xf6f4}, {0xc6e5,0xf6f5}, {0xc6e6,0xf6f6},
    {0xc6e7,0xf6f7}, {0xc6e8,0xf6f8}, {0xc6e9,0xf6f9}, {0xc6ea,0xf6fa}, {0xc6eb,0xf6fb}, {0xc6ec,0xf6fc}, {0xc6ed,0xf6fd}, {0xc6ee,0xf6fe}, {0xc6ef,0xf6ff}, {0xc6f0,0xf700},
    {0xc6f1,0xf701}, {0xc6f2,0xf702}, {0xc6f3,0xf703}, {0xc6f4,0xf704}, {0xc6f5,0xf705}, {0xc6f6,0xf706}, {0xc6f7,0xf707}, {0xc6f8,0xf708}, {0xc6f9,0xf709}, {0xc6fa,0xf70a},
    {0xc6fb,0xf70b}, {0xc6fc,0xf70c}, {0xc6fd,0xf70d}, {0xc6fe,0xf70e}, {0xc740,0xf70f}, {0xc741,0xf710}, {0xc742,0xf711}, {0xc743,0xf712}, {0xc744,0xf713}, {0xc745,0xf714},
    {0xc746,0xf715}, {0xc747,0xf716}, {0xc748,0xf717}, {0xc749,0xf718}, {0xc74a,0xf719}, {0xc74b,0xf71a}, {0xc74c,0xf71b}, {0xc74d,0xf71c}, {0xc74e,0xf71d}, {0xc74f,0xf71e},
    {0xc750,0xf71f}, {0xc751,0xf720}, {0xc752,0xf721}, {0xc753,0xf722}, {0xc754,0xf723}, {0xc755,0xf724}, {0xc756,0xf725}, {0xc757,0xf726}, {0xc758,0xf727}, {0xc759,0xf728},
    {0xc75a,0xf729}, {0xc75b,0xf72a}, {0xc75c,0xf72b}, {0xc75d,0xf72c}, {0xc75e,0xf72d}, {0xc75f,0xf72e}, {0xc760,0xf72f}, {0xc761,0xf730}, {0xc762,0xf731}, {0xc763,0xf732},
    {0xc764,0xf733}, {0xc765,0xf734}, {0xc766,0xf735}, {0xc767,0xf736}, {0xc768,0xf737}, {0xc769,0xf738}, {0xc76a,0xf739}, {0xc76b,0xf73a}, {0xc76c,0xf73b}, {0xc76d,0xf73c},
    {0xc76e,0xf73d}, {0xc76f,0xf73e}, {0xc770,0xf73f}, {0xc771,0xf740}, {0xc772,0xf741}, {0xc773,0xf742}, {0xc774,0xf743}, {0xc775,0xf744}, {0xc776,0xf745}, {0xc777,0xf746},
    {0xc778,0xf747}, {0xc779,0xf748}, {0xc77a,0xf749}, {0xc77b,0xf74a}, {0xc77c,0xf74b}, {0xc77d,0xf74c}, {0xc77e,0xf74d}, {0xc7a1,0xf74e}, {0xc7a2,0xf74f}, {0xc7a3,0xf750},
    {0xc7a4,0xf751}, {0xc7a5,0xf752}, {0xc7a6,0xf753}, {0xc7a7,0xf754}, {0xc7a8,0xf755}, {0xc7a9,0xf756}, {0xc7aa,0xf757}, {0xc7ab,0xf758}, {0xc7ac,0xf759}, {0xc7ad,0xf75a},
    {0xc7ae,0xf75b}, {0xc7af,0xf75c}, {0xc7b0,0xf75d}, {0xc7b1,0xf75e}, {0xc7b2,0xf75f}, {0xc7b3,0xf760}, {0xc7b4,0xf761}, {0xc7b5,0xf762}, {0xc7b6,0xf763}, {0xc7b7,0xf764},
    {0xc7b8,0xf765}, {0xc7b9,0xf766}, {0xc7ba,0xf767}, {0xc7bb,0xf768}, {0xc7bc,0xf769}, {0xc7bd,0xf76a}, {0xc7be,0xf76b}, {0xc7bf,0xf76c}, {0xc7c0,0xf76d}, {0xc7c1,0xf76e},
    {0xc7c2,0xf76f}, {0xc7c3,0xf770}, {0xc7c4,0xf771}, {0xc7c5,0xf772}, {0xc7c6,0xf773}, {0xc7c7,0xf774}, {0xc7c8,0xf775}, {0xc7c9,0xf776}, {0xc7ca,0xf777}, {0xc7cb,0xf778},
    {0xc7cc,0xf779}, {0xc7cd,0xf77a}, {0xc7ce,0xf77b}, {0xc7cf,0xf77c}, {0xc7d0,0xf77d}, {0xc7d1,0xf77e}, {0xc7d2,0xf77f}, {0xc7d3,0xf780}, {0xc7d4,0xf781}, {0xc7d5,0xf782},
    {0xc7d6,0xf783}, {0xc7d7,0xf784}, {0xc7d8,0xf785}, {0xc7d9,0xf786}, {0xc7da,0xf787}, {0xc7db,0xf788}, {0xc7dc,0xf789}, {0xc7dd,0xf78a}, {0xc7de,0xf78b}, {0xc7df,0xf78c},
    {0xc7e0,0xf78d}, {0xc7e1,0xf78e}, {0xc7e2,0xf78f}, {0xc7e3,0xf790}, {0xc7e4,0xf791}, {0xc7e5,0xf792}, {0xc7e6,0xf793}, {0xc7e7,0xf794}, {0xc7e8,0xf795}, {0xc7e9,0xf796},
    {0xc7ea,0xf797}, {0xc7eb,0xf798}, {0xc7ec,0xf799}, {0xc7ed,0xf79a}, {0xc7ee,0xf79b}, {0xc7ef,0xf79c}, {0xc7f0,0xf79d}, {0xc7f1,0xf79e}, {0xc7f2,0xf79f}, {0xc7f3,0xf7a0},
    {0xc7f4,0xf7a1}, {0xc7f5,0xf7a2}, {0xc7f6,0xf7a3}, {0xc7f7,0xf7a4}, {0xc7f8,0xf7a5}, {0xc7f9,0xf7a6}, {0xc7fa,0xf7a7}, {0xc7fb,0xf7a8}, {0xc7fc,0xf7a9}, {0xc7fd,0xf7aa},
    {0xc7fe,0xf7ab}, {0xc840,0xf7ac}, {0xc841,0xf7ad}, {0xc842,0xf7ae}, {0xc843,0xf7af}, {0xc844,0xf7b0}, {0xc845,0xf7b1}, {0xc846,0xf7b2}, {0xc847,0xf7b3}, {0xc848,0xf7b4},
    {0xc849,0xf7b5}, {0xc84a,0xf7b6}, {0xc84b,0xf7b7}, {0xc84c,0xf7b8}, {0xc84d,0xf7b9}, {0xc84e,0xf7ba}, {0xc84f,0xf7bb}, {0xc850,0xf7bc}, {0xc851,0xf7bd}, {0xc852,0xf7be},
    {0xc853,0xf7bf}, {0xc854,0xf7c0}, {0xc855,0xf7c1}, {0xc856,0xf7c2}, {0xc857,0xf7c3}, {0xc858,0xf7c4}, {0xc859,0xf7c5}, {0xc85a,0xf7c6}, {0xc85b,0xf7c7}, {0xc85c,0xf7c8},
    {0xc85d,0xf7c9}, {0xc85e,0xf7ca}, {0xc85f,0xf7cb}, {0xc860,0xf7cc}, {0xc861,0xf7cd}, {0xc862,0xf7ce}, {0xc863,0xf7cf}, {0xc864,0xf7d0}, {0xc865,0xf7d1}, {0xc866,0xf7d2},
    {0xc867,0xf7d3}, {0xc868,0xf7d4}, {0xc869,0xf7d5}, {0xc86a,0xf7d6}, {0xc86b,0xf7d7}, {0xc86c,0xf7d8}, {0xc86d,0xf7d9}, {0xc86e,0xf7da}, {0xc86f,0xf7db}, {0xc870,0xf7dc},
    {0xc871,0xf7dd}, {0xc872,0xf7de}, {0xc873,0xf7df}, {0xc874,0xf7e0}, {0xc875,0xf7e1}, {0xc876,0xf7e2}, {0xc877,0xf7e3}, {0xc878,0xf7e4}, {0xc879,0xf7e5}, {0xc87a,0xf7e6},
    {0xc87b,0xf7e7}, {0xc87c,0xf7e8}, {0xc87d,0xf7e9}, {0xc87e,0xf7ea}, {0xc8a1,0xf7eb}, {0xc8a2,0xf7ec}, {0xc8a3,0xf7ed}, {0xc8a4,0xf7ee}, {0xc8a5,0xf7ef}, {0xc8a6,0xf7f0},
    {0xc8a7,0xf7f1}, {0xc8a8,0xf7f2}, {0xc8a9,0xf7f3}, {0xc8aa,0xf7f4}, {0xc8ab,0xf7f5}, {0xc8ac,0xf7f6}, {0xc8ad,0xf7f7}, {0xc8ae,0xf7f8}, {0xc8af,0xf7f9}, {0xc8b0,0xf7fa},
    {0xc8b1,0xf7fb}, {0xc8b2,0xf7fc}, {0xc8b3,0xf7fd}, {0xc8b4,0xf7fe}, {0xc8b5,0xf7ff}, {0xc8b6,0xf800}, {0xc8b7,0xf801}, {0xc8b8,0xf802}, {0xc8b9,0xf803}, {0xc8ba,0xf804},
    {0xc8bb,0xf805}, {0xc8bc,0xf806}, {0xc8bd,0xf807}, {0xc8be,0xf808}, {0xc8bf,0xf809}, {0xc8c0,0xf80a}, {0xc8c1,0xf80b}, {0xc8c2,0xf80c}, {0xc8c3,0xf80d}, {0xc8c4,0xf80e},
    {0xc8c5,0xf80f}, {0xc8c6,0xf810}, {0xc8c7,0xf811}, {0xc8c8,0xf812}, {0xc8c9,0xf813}, {0xc8ca,0xf814}, {0xc8cb,0xf815}, {0xc8cc,0xf816}, {0xc8cd,0xf817}, {0xc8ce,0xf818},
    {0xc8cf,0xf819}, {0xc8d0,0xf81a}, {0xc8d1,0xf81b}, {0xc8d2,0xf81c}, {0xc8d3,0xf81d}, {0xc8d4,0xf81e}, {0xc8d5,0xf81f}, {0xc8d6,0xf820}, {0xc8d7,0xf821}, {0xc8d8,0xf822},
    {0xc8d9,0xf823}, {0xc8da,0xf824}, {0xc8db,0xf825}, {0xc8dc,0xf826}, {0xc8dd,0xf827}, {0xc8de,0xf828}, {0xc8df,0xf829}, {0xc8e0,0xf82a}, {0xc8e1,0xf82b}, {0xc8e2,0xf82c},
    {0xc8e3,0xf82d}, {0xc8e4,0xf82e}, {0xc8e5,0xf82f}, {0xc8e6,0xf830}, {0xc8e7,0xf831}, {0xc8e8,0xf832}, {0xc8e9,0xf833}, {0xc8ea,0xf834}, {0xc8eb,0xf835}, {0xc8ec,0xf836},
    {0xc8ed,0xf837}, {0xc8ee,0xf838}, {0xc8ef,0xf839}, {0xc8f0,0xf83a}, {0xc8f1,0xf83b}, {0xc8f2,0xf83c}, {0xc8f3,0xf83d}, {0xc8f4,0xf83e}, {0xc8f5,0xf83f}, {0xc8f6,0xf840},
    {0xc8f7,0xf841}, {0xc8f8,0xf842}, {0xc8f9,0xf843}, {0xc8fa,0xf844}, {0xc8fb,0xf845}, {0xc8fc,0xf846}, {0xc8fd,0xf847}, {0xc8fe,0xf848},
};

static const B5Map b5_FA40_to_uc_map[786] = {
    {0xf9fe,0x2593}, {0xfa40,0xe000}, {0xfa41,0xe001}, {0xfa42,0xe002}, {0xfa43,0xe003}, {0xfa44,0xe004}, {0xfa45,0xe005}, {0xfa46,0xe006}, {0xfa47,0xe007}, {0xfa48,0xe008},
    {0xfa49,0xe009}, {0xfa4a,0xe00a}, {0xfa4b,0xe00b}, {0xfa4c,0xe00c}, {0xfa4d,0xe00d}, {0xfa4e,0xe00e}, {0xfa4f,0xe00f}, {0xfa50,0xe010}, {0xfa51,0xe011}, {0xfa52,0xe012},
    {0xfa53,0xe013}, {0xfa54,0xe014}, {0xfa55,0xe015}, {0xfa56,0xe016}, {0xfa57,0xe017}, {0xfa58,0xe018}, {0xfa59,0xe019}, {0xfa5a,0xe01a}, {0xfa5b,0xe01b}, {0xfa5c,0xe01c},
    {0xfa5d,0xe01d}, {0xfa5e,0xe01e}, {0xfa5f,0xe01f}, {0xfa60,0xe020}, {0xfa61,0xe021}, {0xfa62,0xe022}, {0xfa63,0xe023}, {0xfa64,0xe024}, {0xfa65,0xe025}, {0xfa66,0xe026},
    {0xfa67,0xe027}, {0xfa68,0xe028}, {0xfa69,0xe029}, {0xfa6a,0xe02a}, {0xfa6b,0xe02b}, {0xfa6c,0xe02c}, {0xfa6d,0xe02d}, {0xfa6e,0xe02e}, {0xfa6f,0xe02f}, {0xfa70,0xe030},
    {0xfa71,0xe031}, {0xfa72,0xe032}, {0xfa73,0xe033}, {0xfa74,0xe034}, {0xfa75,0xe035}, {0xfa76,0xe036}, {0xfa77,0xe037}, {0xfa78,0xe038}, {0xfa79,0xe039}, {0xfa7a,0xe03a},
    {0xfa7b,0xe03b}, {0xfa7c,0xe03c}, {0xfa7d,0xe03d}, {0xfa7e,0xe03e}, {0xfaa1,0xe03f}, {0xfaa2,0xe040}, {0xfaa3,0xe041}, {0xfaa4,0xe042}, {0xfaa5,0xe043}, {0xfaa6,0xe044},
    {0xfaa7,0xe045}, {0xfaa8,0xe046}, {0xfaa9,0xe047}, {0xfaaa,0xe048}, {0xfaab,0xe049}, {0xfaac,0xe04a}, {0xfaad,0xe04b}, {0xfaae,0xe04c}, {0xfaaf,0xe04d}, {0xfab0,0xe04e},
    {0xfab1,0xe04f}, {0xfab2,0xe050}, {0xfab3,0xe051}, {0xfab4,0xe052}, {0xfab5,0xe053}, {0xfab6,0xe054}, {0xfab7,0xe055}, {0xfab8,0xe056}, {0xfab9,0xe057}, {0xfaba,0xe058},
    {0xfabb,0xe059}, {0xfabc,0xe05a}, {0xfabd,0xe05b}, {0xfabe,0xe05c}, {0xfabf,0xe05d}, {0xfac0,0xe05e}, {0xfac1,0xe05f}, {0xfac2,0xe060}, {0xfac3,0xe061}, {0xfac4,0xe062},
    {0xfac5,0xe063}, {0xfac6,0xe064}, {0xfac7,0xe065}, {0xfac8,0xe066}, {0xfac9,0xe067}, {0xfaca,0xe068}, {0xfacb,0xe069}, {0xfacc,0xe06a}, {0xfacd,0xe06b}, {0xface,0xe06c},
    {0xfacf,0xe06d}, {0xfad0,0xe06e}, {0xfad1,0xe06f}, {0xfad2,0xe070}, {0xfad3,0xe071}, {0xfad4,0xe072}, {0xfad5,0xe073}, {0xfad6,0xe074}, {0xfad7,0xe075}, {0xfad8,0xe076},
    {0xfad9,0xe077}, {0xfada,0xe078}, {0xfadb,0xe079}, {0xfadc,0xe07a}, {0xfadd,0xe07b}, {0xfade,0xe07c}, {0xfadf,0xe07d}, {0xfae0,0xe07e}, {0xfae1,0xe07f}, {0xfae2,0xe080},
    {0xfae3,0xe081}, {0xfae4,0xe082}, {0xfae5,0xe083}, {0xfae6,0xe084}, {0xfae7,0xe085}, {0xfae8,0xe086}, {0xfae9,0xe087}, {0xfaea,0xe088}, {0xfaeb,0xe089}, {0xfaec,0xe08a},
    {0xfaed,0xe08b}, {0xfaee,0xe08c}, {0xfaef,0xe08d}, {0xfaf0,0xe08e}, {0xfaf1,0xe08f}, {0xfaf2,0xe090}, {0xfaf3,0xe091}, {0xfaf4,0xe092}, {0xfaf5,0xe093}, {0xfaf6,0xe094},
    {0xfaf7,0xe095}, {0xfaf8,0xe096}, {0xfaf9,0xe097}, {0xfafa,0xe098}, {0xfafb,0xe099}, {0xfafc,0xe09a}, {0xfafd,0xe09b}, {0xfafe,0xe09c}, {0xfb40,0xe09d}, {0xfb41,0xe09e},
    {0xfb42,0xe09f}, {0xfb43,0xe0a0}, {0xfb44,0xe0a1}, {0xfb45,0xe0a2}, {0xfb46,0xe0a3}, {0xfb47,0xe0a4}, {0xfb48,0xe0a5}, {0xfb49,0xe0a6}, {0xfb4a,0xe0a7}, {0xfb4b,0xe0a8},
    {0xfb4c,0xe0a9}, {0xfb4d,0xe0aa}, {0xfb4e,0xe0ab}, {0xfb4f,0xe0ac}, {0xfb50,0xe0ad}, {0xfb51,0xe0ae}, {0xfb52,0xe0af}, {0xfb53,0xe0b0}, {0xfb54,0xe0b1}, {0xfb55,0xe0b2},
    {0xfb56,0xe0b3}, {0xfb57,0xe0b4}, {0xfb58,0xe0b5}, {0xfb59,0xe0b6}, {0xfb5a,0xe0b7}, {0xfb5b,0xe0b8}, {0xfb5c,0xe0b9}, {0xfb5d,0xe0ba}, {0xfb5e,0xe0bb}, {0xfb5f,0xe0bc},
    {0xfb60,0xe0bd}, {0xfb61,0xe0be}, {0xfb62,0xe0bf}, {0xfb63,0xe0c0}, {0xfb64,0xe0c1}, {0xfb65,0xe0c2}, {0xfb66,0xe0c3}, {0xfb67,0xe0c4}, {0xfb68,0xe0c5}, {0xfb69,0xe0c6},
    {0xfb6a,0xe0c7}, {0xfb6b,0xe0c8}, {0xfb6c,0xe0c9}, {0xfb6d,0xe0ca}, {0xfb6e,0xe0cb}, {0xfb6f,0xe0cc}, {0xfb70,0xe0cd}, {0xfb71,0xe0ce}, {0xfb72,0xe0cf}, {0xfb73,0xe0d0},
    {0xfb74,0xe0d1}, {0xfb75,0xe0d2}, {0xfb76,0xe0d3}, {0xfb77,0xe0d4}, {0xfb78,0xe0d5}, {0xfb79,0xe0d6}, {0xfb7a,0xe0d7}, {0xfb7b,0xe0d8}, {0xfb7c,0xe0d9}, {0xfb7d,0xe0da},
    {0xfb7e,0xe0db}, {0xfba1,0xe0dc}, {0xfba2,0xe0dd}, {0xfba3,0xe0de}, {0xfba4,0xe0df}, {0xfba5,0xe0e0}, {0xfba6,0xe0e1}, {0xfba7,0xe0e2}, {0xfba8,0xe0e3}, {0xfba9,0xe0e4},
    {0xfbaa,0xe0e5}, {0xfbab,0xe0e6}, {0xfbac,0xe0e7}, {0xfbad,0xe0e8}, {0xfbae,0xe0e9}, {0xfbaf,0xe0ea}, {0xfbb0,0xe0eb}, {0xfbb1,0xe0ec}, {0xfbb2,0xe0ed}, {0xfbb3,0xe0ee},
    {0xfbb4,0xe0ef}, {0xfbb5,0xe0f0}, {0xfbb6,0xe0f1}, {0xfbb7,0xe0f2}, {0xfbb8,0xe0f3}, {0xfbb9,0xe0f4}, {0xfbba,0xe0f5}, {0xfbbb,0xe0f6}, {0xfbbc,0xe0f7}, {0xfbbd,0xe0f8},
    {0xfbbe,0xe0f9}, {0xfbbf,0xe0fa}, {0xfbc0,0xe0fb}, {0xfbc1,0xe0fc}, {0xfbc2,0xe0fd}, {0xfbc3,0xe0fe}, {0xfbc4,0xe0ff}, {0xfbc5,0xe100}, {0xfbc6,0xe101}, {0xfbc7,0xe102},
    {0xfbc8,0xe103}, {0xfbc9,0xe104}, {0xfbca,0xe105}, {0xfbcb,0xe106}, {0xfbcc,0xe107}, {0xfbcd,0xe108}, {0xfbce,0xe109}, {0xfbcf,0xe10a}, {0xfbd0,0xe10b}, {0xfbd1,0xe10c},
    {0xfbd2,0xe10d}, {0xfbd3,0xe10e}, {0xfbd4,0xe10f}, {0xfbd5,0xe110}, {0xfbd6,0xe111}, {0xfbd7,0xe112}, {0xfbd8,0xe113}, {0xfbd9,0xe114}, {0xfbda,0xe115}, {0xfbdb,0xe116},
    {0xfbdc,0xe117}, {0xfbdd,0xe118}, {0xfbde,0xe119}, {0xfbdf,0xe11a}, {0xfbe0,0xe11b}, {0xfbe1,0xe11c}, {0xfbe2,0xe11d}, {0xfbe3,0xe11e}, {0xfbe4,0xe11f}, {0xfbe5,0xe120},
    {0xfbe6,0xe121}, {0xfbe7,0xe122}, {0xfbe8,0xe123}, {0xfbe9,0xe124}, {0xfbea,0xe125}, {0xfbeb,0xe126}, {0xfbec,0xe127}, {0xfbed,0xe128}, {0xfbee,0xe129}, {0xfbef,0xe12a},
    {0xfbf0,0xe12b}, {0xfbf1,0xe12c}, {0xfbf2,0xe12d}, {0xfbf3,0xe12e}, {0xfbf4,0xe12f}, {0xfbf5,0xe130}, {0xfbf6,0xe131}, {0xfbf7,0xe132}, {0xfbf8,0xe133}, {0xfbf9,0xe134},
    {0xfbfa,0xe135}, {0xfbfb,0xe136}, {0xfbfc,0xe137}, {0xfbfd,0xe138}, {0xfbfe,0xe139}, {0xfc40,0xe13a}, {0xfc41,0xe13b}, {0xfc42,0xe13c}, {0xfc43,0xe13d}, {0xfc44,0xe13e},
    {0xfc45,0xe13f}, {0xfc46,0xe140}, {0xfc47,0xe141}, {0xfc48,0xe142}, {0xfc49,0xe143}, {0xfc4a,0xe144}, {0xfc4b,0xe145}, {0xfc4c,0xe146}, {0xfc4d,0xe147}, {0xfc4e,0xe148},
    {0xfc4f,0xe149}, {0xfc50,0xe14a}, {0xfc51,0xe14b}, {0xfc52,0xe14c}, {0xfc53,0xe14d}, {0xfc54,0xe14e}, {0xfc55,0xe14f}, {0xfc56,0xe150}, {0xfc57,0xe151}, {0xfc58,0xe152},
    {0xfc59,0xe153}, {0xfc5a,0xe154}, {0xfc5b,0xe155}, {0xfc5c,0xe156}, {0xfc5d,0xe157}, {0xfc5e,0xe158}, {0xfc5f,0xe159}, {0xfc60,0xe15a}, {0xfc61,0xe15b}, {0xfc62,0xe15c},
    {0xfc63,0xe15d}, {0xfc64,0xe15e}, {0xfc65,0xe15f}, {0xfc66,0xe160}, {0xfc67,0xe161}, {0xfc68,0xe162}, {0xfc69,0xe163}, {0xfc6a,0xe164}, {0xfc6b,0xe165}, {0xfc6c,0xe166},
    {0xfc6d,0xe167}, {0xfc6e,0xe168}, {0xfc6f,0xe169}, {0xfc70,0xe16a}, {0xfc71,0xe16b}, {0xfc72,0xe16c}, {0xfc73,0xe16d}, {0xfc74,0xe16e}, {0xfc75,0xe16f}, {0xfc76,0xe170},
    {0xfc77,0xe171}, {0xfc78,0xe172}, {0xfc79,0xe173}, {0xfc7a,0xe174}, {0xfc7b,0xe175}, {0xfc7c,0xe176}, {0xfc7d,0xe177}, {0xfc7e,0xe178}, {0xfca1,0xe179}, {0xfca2,0xe17a},
    {0xfca3,0xe17b}, {0xfca4,0xe17c}, {0xfca5,0xe17d}, {0xfca6,0xe17e}, {0xfca7,0xe17f}, {0xfca8,0xe180}, {0xfca9,0xe181}, {0xfcaa,0xe182}, {0xfcab,0xe183}, {0xfcac,0xe184},
    {0xfcad,0xe185}, {0xfcae,0xe186}, {0xfcaf,0xe187}, {0xfcb0,0xe188}, {0xfcb1,0xe189}, {0xfcb2,0xe18a}, {0xfcb3,0xe18b}, {0xfcb4,0xe18c}, {0xfcb5,0xe18d}, {0xfcb6,0xe18e},
    {0xfcb7,0xe18f}, {0xfcb8,0xe190}, {0xfcb9,0xe191}, {0xfcba,0xe192}, {0xfcbb,0xe193}, {0xfcbc,0xe194}, {0xfcbd,0xe195}, {0xfcbe,0xe196}, {0xfcbf,0xe197}, {0xfcc0,0xe198},
    {0xfcc1,0xe199}, {0xfcc2,0xe19a}, {0xfcc3,0xe19b}, {0xfcc4,0xe19c}, {0xfcc5,0xe19d}, {0xfcc6,0xe19e}, {0xfcc7,0xe19f}, {0xfcc8,0xe1a0}, {0xfcc9,0xe1a1}, {0xfcca,0xe1a2},
    {0xfccb,0xe1a3}, {0xfccc,0xe1a4}, {0xfccd,0xe1a5}, {0xfcce,0xe1a6}, {0xfccf,0xe1a7}, {0xfcd0,0xe1a8}, {0xfcd1,0xe1a9}, {0xfcd2,0xe1aa}, {0xfcd3,0xe1ab}, {0xfcd4,0xe1ac},
    {0xfcd5,0xe1ad}, {0xfcd6,0xe1ae}, {0xfcd7,0xe1af}, {0xfcd8,0xe1b0}, {0xfcd9,0xe1b1}, {0xfcda,0xe1b2}, {0xfcdb,0xe1b3}, {0xfcdc,0xe1b4}, {0xfcdd,0xe1b5}, {0xfcde,0xe1b6},
    {0xfcdf,0xe1b7}, {0xfce0,0xe1b8}, {0xfce1,0xe1b9}, {0xfce2,0xe1ba}, {0xfce3,0xe1bb}, {0xfce4,0xe1bc}, {0xfce5,0xe1bd}, {0xfce6,0xe1be}, {0xfce7,0xe1bf}, {0xfce8,0xe1c0},
    {0xfce9,0xe1c1}, {0xfcea,0xe1c2}, {0xfceb,0xe1c3}, {0xfcec,0xe1c4}, {0xfced,0xe1c5}, {0xfcee,0xe1c6}, {0xfcef,0xe1c7}, {0xfcf0,0xe1c8}, {0xfcf1,0xe1c9}, {0xfcf2,0xe1ca},
    {0xfcf3,0xe1cb}, {0xfcf4,0xe1cc}, {0xfcf5,0xe1cd}, {0xfcf6,0xe1ce}, {0xfcf7,0xe1cf}, {0xfcf8,0xe1d0}, {0xfcf9,0xe1d1}, {0xfcfa,0xe1d2}, {0xfcfb,0xe1d3}, {0xfcfc,0xe1d4},
    {0xfcfd,0xe1d5}, {0xfcfe,0xe1d6}, {0xfd40,0xe1d7}, {0xfd41,0xe1d8}, {0xfd42,0xe1d9}, {0xfd43,0xe1da}, {0xfd44,0xe1db}, {0xfd45,0xe1dc}, {0xfd46,0xe1dd}, {0xfd47,0xe1de},
    {0xfd48,0xe1df}, {0xfd49,0xe1e0}, {0xfd4a,0xe1e1}, {0xfd4b,0xe1e2}, {0xfd4c,0xe1e3}, {0xfd4d,0xe1e4}, {0xfd4e,0xe1e5}, {0xfd4f,0xe1e6}, {0xfd50,0xe1e7}, {0xfd51,0xe1e8},
    {0xfd52,0xe1e9}, {0xfd53,0xe1ea}, {0xfd54,0xe1eb}, {0xfd55,0xe1ec}, {0xfd56,0xe1ed}, {0xfd57,0xe1ee}, {0xfd58,0xe1ef}, {0xfd59,0xe1f0}, {0xfd5a,0xe1f1}, {0xfd5b,0xe1f2},
    {0xfd5c,0xe1f3}, {0xfd5d,0xe1f4}, {0xfd5e,0xe1f5}, {0xfd5f,0xe1f6}, {0xfd60,0xe1f7}, {0xfd61,0xe1f8}, {0xfd62,0xe1f9}, {0xfd63,0xe1fa}, {0xfd64,0xe1fb}, {0xfd65,0xe1fc},
    {0xfd66,0xe1fd}, {0xfd67,0xe1fe}, {0xfd68,0xe1ff}, {0xfd69,0xe200}, {0xfd6a,0xe201}, {0xfd6b,0xe202}, {0xfd6c,0xe203}, {0xfd6d,0xe204}, {0xfd6e,0xe205}, {0xfd6f,0xe206},
    {0xfd70,0xe207}, {0xfd71,0xe208}, {0xfd72,0xe209}, {0xfd73,0xe20a}, {0xfd74,0xe20b}, {0xfd75,0xe20c}, {0xfd76,0xe20d}, {0xfd77,0xe20e}, {0xfd78,0xe20f}, {0xfd79,0xe210},
    {0xfd7a,0xe211}, {0xfd7b,0xe212}, {0xfd7c,0xe213}, {0xfd7d,0xe214}, {0xfd7e,0xe215}, {0xfda1,0xe216}, {0xfda2,0xe217}, {0xfda3,0xe218}, {0xfda4,0xe219}, {0xfda5,0xe21a},
    {0xfda6,0xe21b}, {0xfda7,0xe21c}, {0xfda8,0xe21d}, {0xfda9,0xe21e}, {0xfdaa,0xe21f}, {0xfdab,0xe220}, {0xfdac,0xe221}, {0xfdad,0xe222}, {0xfdae,0xe223}, {0xfdaf,0xe224},
    {0xfdb0,0xe225}, {0xfdb1,0xe226}, {0xfdb2,0xe227}, {0xfdb3,0xe228}, {0xfdb4,0xe229}, {0xfdb5,0xe22a}, {0xfdb6,0xe22b}, {0xfdb7,0xe22c}, {0xfdb8,0xe22d}, {0xfdb9,0xe22e},
    {0xfdba,0xe22f}, {0xfdbb,0xe230}, {0xfdbc,0xe231}, {0xfdbd,0xe232}, {0xfdbe,0xe233}, {0xfdbf,0xe234}, {0xfdc0,0xe235}, {0xfdc1,0xe236}, {0xfdc2,0xe237}, {0xfdc3,0xe238},
    {0xfdc4,0xe239}, {0xfdc5,0xe23a}, {0xfdc6,0xe23b}, {0xfdc7,0xe23c}, {0xfdc8,0xe23d}, {0xfdc9,0xe23e}, {0xfdca,0xe23f}, {0xfdcb,0xe240}, {0xfdcc,0xe241}, {0xfdcd,0xe242},
    {0xfdce,0xe243}, {0xfdcf,0xe244}, {0xfdd0,0xe245}, {0xfdd1,0xe246}, {0xfdd2,0xe247}, {0xfdd3,0xe248}, {0xfdd4,0xe249}, {0xfdd5,0xe24a}, {0xfdd6,0xe24b}, {0xfdd7,0xe24c},
    {0xfdd8,0xe24d}, {0xfdd9,0xe24e}, {0xfdda,0xe24f}, {0xfddb,0xe250}, {0xfddc,0xe251}, {0xfddd,0xe252}, {0xfdde,0xe253}, {0xfddf,0xe254}, {0xfde0,0xe255}, {0xfde1,0xe256},
    {0xfde2,0xe257}, {0xfde3,0xe258}, {0xfde4,0xe259}, {0xfde5,0xe25a}, {0xfde6,0xe25b}, {0xfde7,0xe25c}, {0xfde8,0xe25d}, {0xfde9,0xe25e}, {0xfdea,0xe25f}, {0xfdeb,0xe260},
    {0xfdec,0xe261}, {0xfded,0xe262}, {0xfdee,0xe263}, {0xfdef,0xe264}, {0xfdf0,0xe265}, {0xfdf1,0xe266}, {0xfdf2,0xe267}, {0xfdf3,0xe268}, {0xfdf4,0xe269}, {0xfdf5,0xe26a},
    {0xfdf6,0xe26b}, {0xfdf7,0xe26c}, {0xfdf8,0xe26d}, {0xfdf9,0xe26e}, {0xfdfa,0xe26f}, {0xfdfb,0xe270}, {0xfdfc,0xe271}, {0xfdfd,0xe272}, {0xfdfe,0xe273}, {0xfe40,0xe274},
    {0xfe41,0xe275}, {0xfe42,0xe276}, {0xfe43,0xe277}, {0xfe44,0xe278}, {0xfe45,0xe279}, {0xfe46,0xe27a}, {0xfe47,0xe27b}, {0xfe48,0xe27c}, {0xfe49,0xe27d}, {0xfe4a,0xe27e},
    {0xfe4b,0xe27f}, {0xfe4c,0xe280}, {0xfe4d,0xe281}, {0xfe4e,0xe282}, {0xfe4f,0xe283}, {0xfe50,0xe284}, {0xfe51,0xe285}, {0xfe52,0xe286}, {0xfe53,0xe287}, {0xfe54,0xe288},
    {0xfe55,0xe289}, {0xfe56,0xe28a}, {0xfe57,0xe28b}, {0xfe58,0xe28c}, {0xfe59,0xe28d}, {0xfe5a,0xe28e}, {0xfe5b,0xe28f}, {0xfe5c,0xe290}, {0xfe5d,0xe291}, {0xfe5e,0xe292},
    {0xfe5f,0xe293}, {0xfe60,0xe294}, {0xfe61,0xe295}, {0xfe62,0xe296}, {0xfe63,0xe297}, {0xfe64,0xe298}, {0xfe65,0xe299}, {0xfe66,0xe29a}, {0xfe67,0xe29b}, {0xfe68,0xe29c},
    {0xfe69,0xe29d}, {0xfe6a,0xe29e}, {0xfe6b,0xe29f}, {0xfe6c,0xe2a0}, {0xfe6d,0xe2a1}, {0xfe6e,0xe2a2}, {0xfe6f,0xe2a3}, {0xfe70,0xe2a4}, {0xfe71,0xe2a5}, {0xfe72,0xe2a6},
    {0xfe73,0xe2a7}, {0xfe74,0xe2a8}, {0xfe75,0xe2a9}, {0xfe76,0xe2aa}, {0xfe77,0xe2ab}, {0xfe78,0xe2ac}, {0xfe79,0xe2ad}, {0xfe7a,0xe2ae}, {0xfe7b,0xe2af}, {0xfe7c,0xe2b0},
    {0xfe7d,0xe2b1}, {0xfe7e,0xe2b2}, {0xfea1,0xe2b3}, {0xfea2,0xe2b4}, {0xfea3,0xe2b5}, {0xfea4,0xe2b6}, {0xfea5,0xe2b7}, {0xfea6,0xe2b8}, {0xfea7,0xe2b9}, {0xfea8,0xe2ba},
    {0xfea9,0xe2bb}, {0xfeaa,0xe2bc}, {0xfeab,0xe2bd}, {0xfeac,0xe2be}, {0xfead,0xe2bf}, {0xfeae,0xe2c0}, {0xfeaf,0xe2c1}, {0xfeb0,0xe2c2}, {0xfeb1,0xe2c3}, {0xfeb2,0xe2c4},
    {0xfeb3,0xe2c5}, {0xfeb4,0xe2c6}, {0xfeb5,0xe2c7}, {0xfeb6,0xe2c8}, {0xfeb7,0xe2c9}, {0xfeb8,0xe2ca}, {0xfeb9,0xe2cb}, {0xfeba,0xe2cc}, {0xfebb,0xe2cd}, {0xfebc,0xe2ce},
    {0xfebd,0xe2cf}, {0xfebe,0xe2d0}, {0xfebf,0xe2d1}, {0xfec0,0xe2d2}, {0xfec1,0xe2d3}, {0xfec2,0xe2d4}, {0xfec3,0xe2d5}, {0xfec4,0xe2d6}, {0xfec5,0xe2d7}, {0xfec6,0xe2d8},
    {0xfec7,0xe2d9}, {0xfec8,0xe2da}, {0xfec9,0xe2db}, {0xfeca,0xe2dc}, {0xfecb,0xe2dd}, {0xfecc,0xe2de}, {0xfecd,0xe2df}, {0xfece,0xe2e0}, {0xfecf,0xe2e1}, {0xfed0,0xe2e2},
    {0xfed1,0xe2e3}, {0xfed2,0xe2e4}, {0xfed3,0xe2e5}, {0xfed4,0xe2e6}, {0xfed5,0xe2e7}, {0xfed6,0xe2e8}, {0xfed7,0xe2e9}, {0xfed8,0xe2ea}, {0xfed9,0xe2eb}, {0xfeda,0xe2ec},
    {0xfedb,0xe2ed}, {0xfedc,0xe2ee}, {0xfedd,0xe2ef}, {0xfede,0xe2f0}, {0xfedf,0xe2f1}, {0xfee0,0xe2f2}, {0xfee1,0xe2f3}, {0xfee2,0xe2f4}, {0xfee3,0xe2f5}, {0xfee4,0xe2f6},
    {0xfee5,0xe2f7}, {0xfee6,0xe2f8}, {0xfee7,0xe2f9}, {0xfee8,0xe2fa}, {0xfee9,0xe2fb}, {0xfeea,0xe2fc}, {0xfeeb,0xe2fd}, {0xfeec,0xe2fe}, {0xfeed,0xe2ff}, {0xfeee,0xe300},
    {0xfeef,0xe301}, {0xfef0,0xe302}, {0xfef1,0xe303}, {0xfef2,0xe304}, {0xfef3,0xe305}, {0xfef4,0xe306}, {0xfef5,0xe307}, {0xfef6,0xe308}, {0xfef7,0xe309}, {0xfef8,0xe30a},
    {0xfef9,0xe30b}, {0xfefa,0xe30c}, {0xfefb,0xe30d}, {0xfefc,0xe30e}, {0xfefd,0xe30f}, {0xfefe,0xe310},
};

static const B5Map uc_to_b5_map[8] = {
    {0xa2a4,0x2550}, {0xa2a5,0x255e}, {0xa2a7,0x2561}, {0xa2a6,0x256a}, {0xa27e,0x256d}, {0xa2a1,0x256e}, {0xa2a3,0x256f}, {0xa2a2,0x2570},
};

//All the tables  are sorted on both x and y, so can be used for binary search
const B5Index b5_map_table[5] = {
	{ b5_8140_to_uc_map , std::extent<decltype(b5_8140_to_uc_map)>::value },
	{ b5_8E40_to_uc_map , std::extent<decltype(b5_8E40_to_uc_map)>::value },
	{ b5_C6A1_to_uc_map , std::extent<decltype(b5_C6A1_to_uc_map)>::value },
	{ b5_FA40_to_uc_map , std::extent<decltype(b5_FA40_to_uc_map)>::value },
	{ uc_to_b5_map , std::extent<decltype(uc_to_b5_map)>::value },
};
