package containerregistry

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"io"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/containerregistry/runtime/2019-08-15-preview/containerregistry"

// AccessToken ...
type AccessToken struct {
	autorest.Response `json:"-"`
	// AccessToken - The access token for performing authenticated requests
	AccessToken *string `json:"access_token,omitempty"`
}

// AcrErrorInfo error information
type AcrErrorInfo struct {
	// Code - Error code
	Code *string `json:"code,omitempty"`
	// Message - Error message
	Message *string `json:"message,omitempty"`
	// Detail - Error details
	Detail interface{} `json:"detail,omitempty"`
}

// AcrErrors acr error response describing why the operation failed
type AcrErrors struct {
	// Errors - Array of detailed error
	Errors *[]AcrErrorInfo `json:"errors,omitempty"`
}

// AcrManifests manifest attributes
type AcrManifests struct {
	autorest.Response `json:"-"`
	// Registry - Registry name
	Registry *string `json:"registry,omitempty"`
	// ImageName - Image name
	ImageName *string `json:"imageName,omitempty"`
	// ManifestsAttributes - List of manifests
	ManifestsAttributes *[]ManifestAttributesBase `json:"manifests,omitempty"`
}

// Annotations additional information provided through arbitrary metadata.
type Annotations struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Created - Date and time on which the image was built (string, date-time as defined by https://tools.ietf.org/html/rfc3339#section-5.6)
	Created *date.Time `json:"org.opencontainers.image.created,omitempty"`
	// Authors - Contact details of the people or organization responsible for the image.
	Authors *string `json:"org.opencontainers.image.authors,omitempty"`
	// URL - URL to find more information on the image.
	URL *string `json:"org.opencontainers.image.url,omitempty"`
	// Documentation - URL to get documentation on the image.
	Documentation *string `json:"org.opencontainers.image.documentation,omitempty"`
	// Source - URL to get source code for building the image.
	Source *string `json:"org.opencontainers.image.source,omitempty"`
	// Version - Version of the packaged software. The version MAY match a label or tag in the source code repository, may also be Semantic versioning-compatible
	Version *string `json:"org.opencontainers.image.version,omitempty"`
	// Revision - Source control revision identifier for the packaged software.
	Revision *string `json:"org.opencontainers.image.revision,omitempty"`
	// Vendor - Name of the distributing entity, organization or individual.
	Vendor *string `json:"org.opencontainers.image.vendor,omitempty"`
	// Licenses - License(s) under which contained software is distributed as an SPDX License Expression.
	Licenses *string `json:"org.opencontainers.image.licenses,omitempty"`
	// Name - Name of the reference for a target.
	Name *string `json:"org.opencontainers.image.ref.name,omitempty"`
	// Title - Human-readable title of the image
	Title *string `json:"org.opencontainers.image.title,omitempty"`
	// Description - Human-readable description of the software packaged in the image
	Description *string `json:"org.opencontainers.image.description,omitempty"`
}

// MarshalJSON is the custom marshaler for Annotations.
func (a Annotations) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.Created != nil {
		objectMap["org.opencontainers.image.created"] = a.Created
	}
	if a.Authors != nil {
		objectMap["org.opencontainers.image.authors"] = a.Authors
	}
	if a.URL != nil {
		objectMap["org.opencontainers.image.url"] = a.URL
	}
	if a.Documentation != nil {
		objectMap["org.opencontainers.image.documentation"] = a.Documentation
	}
	if a.Source != nil {
		objectMap["org.opencontainers.image.source"] = a.Source
	}
	if a.Version != nil {
		objectMap["org.opencontainers.image.version"] = a.Version
	}
	if a.Revision != nil {
		objectMap["org.opencontainers.image.revision"] = a.Revision
	}
	if a.Vendor != nil {
		objectMap["org.opencontainers.image.vendor"] = a.Vendor
	}
	if a.Licenses != nil {
		objectMap["org.opencontainers.image.licenses"] = a.Licenses
	}
	if a.Name != nil {
		objectMap["org.opencontainers.image.ref.name"] = a.Name
	}
	if a.Title != nil {
		objectMap["org.opencontainers.image.title"] = a.Title
	}
	if a.Description != nil {
		objectMap["org.opencontainers.image.description"] = a.Description
	}
	for k, v := range a.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Annotations struct.
func (a *Annotations) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if a.AdditionalProperties == nil {
					a.AdditionalProperties = make(map[string]interface{})
				}
				a.AdditionalProperties[k] = additionalProperties
			}
		case "org.opencontainers.image.created":
			if v != nil {
				var created date.Time
				err = json.Unmarshal(*v, &created)
				if err != nil {
					return err
				}
				a.Created = &created
			}
		case "org.opencontainers.image.authors":
			if v != nil {
				var authors string
				err = json.Unmarshal(*v, &authors)
				if err != nil {
					return err
				}
				a.Authors = &authors
			}
		case "org.opencontainers.image.url":
			if v != nil {
				var URL string
				err = json.Unmarshal(*v, &URL)
				if err != nil {
					return err
				}
				a.URL = &URL
			}
		case "org.opencontainers.image.documentation":
			if v != nil {
				var documentation string
				err = json.Unmarshal(*v, &documentation)
				if err != nil {
					return err
				}
				a.Documentation = &documentation
			}
		case "org.opencontainers.image.source":
			if v != nil {
				var source string
				err = json.Unmarshal(*v, &source)
				if err != nil {
					return err
				}
				a.Source = &source
			}
		case "org.opencontainers.image.version":
			if v != nil {
				var version string
				err = json.Unmarshal(*v, &version)
				if err != nil {
					return err
				}
				a.Version = &version
			}
		case "org.opencontainers.image.revision":
			if v != nil {
				var revision string
				err = json.Unmarshal(*v, &revision)
				if err != nil {
					return err
				}
				a.Revision = &revision
			}
		case "org.opencontainers.image.vendor":
			if v != nil {
				var vendor string
				err = json.Unmarshal(*v, &vendor)
				if err != nil {
					return err
				}
				a.Vendor = &vendor
			}
		case "org.opencontainers.image.licenses":
			if v != nil {
				var licenses string
				err = json.Unmarshal(*v, &licenses)
				if err != nil {
					return err
				}
				a.Licenses = &licenses
			}
		case "org.opencontainers.image.ref.name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				a.Name = &name
			}
		case "org.opencontainers.image.title":
			if v != nil {
				var title string
				err = json.Unmarshal(*v, &title)
				if err != nil {
					return err
				}
				a.Title = &title
			}
		case "org.opencontainers.image.description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				a.Description = &description
			}
		}
	}

	return nil
}

// ChangeableAttributes ...
type ChangeableAttributes struct {
	// DeleteEnabled - Delete enabled
	DeleteEnabled *bool `json:"deleteEnabled,omitempty"`
	// WriteEnabled - Write enabled
	WriteEnabled *bool `json:"writeEnabled,omitempty"`
	// ListEnabled - List enabled
	ListEnabled *bool `json:"listEnabled,omitempty"`
	// ReadEnabled - Read enabled
	ReadEnabled *bool `json:"readEnabled,omitempty"`
}

// DeletedRepository deleted repository
type DeletedRepository struct {
	autorest.Response `json:"-"`
	// ManifestsDeleted - SHA of the deleted image
	ManifestsDeleted *[]string `json:"manifestsDeleted,omitempty"`
	// TagsDeleted - Tag of the deleted image
	TagsDeleted *[]string `json:"tagsDeleted,omitempty"`
}

// Descriptor docker V2 image layer descriptor including config and layers
type Descriptor struct {
	// MediaType - Layer media type
	MediaType *string `json:"mediaType,omitempty"`
	// Size - Layer size
	Size *int64 `json:"size,omitempty"`
	// Digest - Layer digest
	Digest *string `json:"digest,omitempty"`
	// Urls - Specifies a list of URIs from which this object may be downloaded.
	Urls        *[]string    `json:"urls,omitempty"`
	Annotations *Annotations `json:"annotations,omitempty"`
}

// FsLayer image layer information
type FsLayer struct {
	// BlobSum - SHA of an image layer
	BlobSum *string `json:"blobSum,omitempty"`
}

// History a list of unstructured historical data for v1 compatibility
type History struct {
	// V1Compatibility - The raw v1 compatibility information
	V1Compatibility *string `json:"v1Compatibility,omitempty"`
}

// ImageSignature signature of a signed manifest
type ImageSignature struct {
	// Header - A JSON web signature
	Header *JWK `json:"header,omitempty"`
	// Signature - A signature for the image manifest, signed by a libtrust private key
	Signature *string `json:"signature,omitempty"`
	// Protected - The signed protected header
	Protected *string `json:"protected,omitempty"`
}

// JWK a JSON web signature
type JWK struct {
	Jwk *JWKHeader `json:"jwk,omitempty"`
	// Alg - The algorithm used to sign or encrypt the JWT
	Alg *string `json:"alg,omitempty"`
}

// JWKHeader JSON web key parameter
type JWKHeader struct {
	// Crv - crv value
	Crv *string `json:"crv,omitempty"`
	// Kid - kid value
	Kid *string `json:"kid,omitempty"`
	// Kty - kty value
	Kty *string `json:"kty,omitempty"`
	// X - x value
	X *string `json:"x,omitempty"`
	// Y - y value
	Y *string `json:"y,omitempty"`
}

// Manifest returns the requested manifest file
type Manifest struct {
	// SchemaVersion - Schema version
	SchemaVersion *int32 `json:"schemaVersion,omitempty"`
}

// ManifestAttributes manifest attributes details
type ManifestAttributes struct {
	autorest.Response `json:"-"`
	// Registry - Registry name
	Registry *string `json:"registry,omitempty"`
	// ImageName - Image name
	ImageName *string `json:"imageName,omitempty"`
	// Attributes - Manifest attributes
	Attributes *ManifestAttributesBase `json:"manifest,omitempty"`
}

// ManifestAttributesBase manifest details
type ManifestAttributesBase struct {
	// Digest - Manifest
	Digest *string `json:"digest,omitempty"`
	// ImageSize - Image size
	ImageSize *int64 `json:"imageSize,omitempty"`
	// CreatedTime - Created time
	CreatedTime *string `json:"createdTime,omitempty"`
	// LastUpdateTime - Last update time
	LastUpdateTime *string `json:"lastUpdateTime,omitempty"`
	// Architecture - CPU architecture
	Architecture *string `json:"architecture,omitempty"`
	// Os - Operating system
	Os *string `json:"os,omitempty"`
	// MediaType - Media type
	MediaType *string `json:"mediaType,omitempty"`
	// ConfigMediaType - Config blob media type
	ConfigMediaType *string `json:"configMediaType,omitempty"`
	// Tags - List of tags
	Tags *[]string `json:"tags,omitempty"`
	// ChangeableAttributes - Changeable attributes
	ChangeableAttributes *ChangeableAttributes `json:"changeableAttributes,omitempty"`
}

// ManifestAttributesManifest list of manifest attributes
type ManifestAttributesManifest struct {
	// References - List of manifest attributes details
	References *[]ManifestAttributesManifestReferences `json:"references,omitempty"`
	// QuarantineTag - Quarantine tag name
	QuarantineTag *string `json:"quarantineTag,omitempty"`
}

// ManifestAttributesManifestReferences manifest attributes details
type ManifestAttributesManifestReferences struct {
	// Digest - Manifest digest
	Digest *string `json:"digest,omitempty"`
	// Architecture - CPU architecture
	Architecture *string `json:"architecture,omitempty"`
	// Os - Operating system
	Os *string `json:"os,omitempty"`
}

// ManifestChangeableAttributes changeable attributes
type ManifestChangeableAttributes struct {
	// DeleteEnabled - Delete enabled
	DeleteEnabled *bool `json:"deleteEnabled,omitempty"`
	// WriteEnabled - Write enabled
	WriteEnabled *bool `json:"writeEnabled,omitempty"`
	// ListEnabled - List enabled
	ListEnabled *bool `json:"listEnabled,omitempty"`
	// ReadEnabled - Read enabled
	ReadEnabled *bool `json:"readEnabled,omitempty"`
	// QuarantineState - Quarantine state
	QuarantineState *string `json:"quarantineState,omitempty"`
	// QuarantineDetails - Quarantine details
	QuarantineDetails *string `json:"quarantineDetails,omitempty"`
}

// ManifestList returns the requested Docker multi-arch-manifest file
type ManifestList struct {
	// MediaType - Media type for this Manifest
	MediaType *string `json:"mediaType,omitempty"`
	// Manifests - List of V2 image layer information
	Manifests *[]ManifestListAttributes `json:"manifests,omitempty"`
	// SchemaVersion - Schema version
	SchemaVersion *int32 `json:"schemaVersion,omitempty"`
}

// ManifestListAttributes ...
type ManifestListAttributes struct {
	// MediaType - The MIME type of the referenced object. This will generally be application/vnd.docker.image.manifest.v2+json, but it could also be application/vnd.docker.image.manifest.v1+json
	MediaType *string `json:"mediaType,omitempty"`
	// Size - The size in bytes of the object
	Size *int64 `json:"size,omitempty"`
	// Digest - The digest of the content, as defined by the Registry V2 HTTP API Specification
	Digest   *string   `json:"digest,omitempty"`
	Platform *Platform `json:"platform,omitempty"`
}

// ManifestWrapper returns the requested manifest file
type ManifestWrapper struct {
	autorest.Response `json:"-"`
	// MediaType - Media type for this Manifest
	MediaType *string `json:"mediaType,omitempty"`
	// Manifests - (ManifestList, OCIIndex) List of V2 image layer information
	Manifests *[]ManifestListAttributes `json:"manifests,omitempty"`
	// Config - (V2, OCI) Image config descriptor
	Config *Descriptor `json:"config,omitempty"`
	// Layers - (V2, OCI) List of V2 image layer information
	Layers *[]Descriptor `json:"layers,omitempty"`
	// Annotations - (OCI, OCIIndex) Additional metadata
	Annotations *Annotations `json:"annotations,omitempty"`
	// Architecture - (V1) CPU architecture
	Architecture *string `json:"architecture,omitempty"`
	// Name - (V1) Image name
	Name *string `json:"name,omitempty"`
	// Tag - (V1) Image tag
	Tag *string `json:"tag,omitempty"`
	// FsLayers - (V1) List of layer information
	FsLayers *[]FsLayer `json:"fsLayers,omitempty"`
	// History - (V1) Image history
	History *[]History `json:"history,omitempty"`
	// Signatures - (V1) Image signature
	Signatures *[]ImageSignature `json:"signatures,omitempty"`
	// SchemaVersion - Schema version
	SchemaVersion *int32 `json:"schemaVersion,omitempty"`
}

// OCIIndex returns the requested OCI index file
type OCIIndex struct {
	// Manifests - List of OCI image layer information
	Manifests   *[]ManifestListAttributes `json:"manifests,omitempty"`
	Annotations *Annotations              `json:"annotations,omitempty"`
	// SchemaVersion - Schema version
	SchemaVersion *int32 `json:"schemaVersion,omitempty"`
}

// OCIManifest returns the requested OCI Manifest file
type OCIManifest struct {
	// Config - V2 image config descriptor
	Config *Descriptor `json:"config,omitempty"`
	// Layers - List of V2 image layer information
	Layers      *[]Descriptor `json:"layers,omitempty"`
	Annotations *Annotations  `json:"annotations,omitempty"`
	// SchemaVersion - Schema version
	SchemaVersion *int32 `json:"schemaVersion,omitempty"`
}

// Platform the platform object describes the platform which the image in the manifest runs on. A full list
// of valid operating system and architecture values are listed in the Go language documentation for $GOOS
// and $GOARCH
type Platform struct {
	// Architecture - Specifies the CPU architecture, for example amd64 or ppc64le.
	Architecture *string `json:"architecture,omitempty"`
	// Os - The os field specifies the operating system, for example linux or windows.
	Os *string `json:"os,omitempty"`
	// OsVersion - The optional os.version field specifies the operating system version, for example 10.0.10586.
	OsVersion *string `json:"os.version,omitempty"`
	// OsFeatures - The optional os.features field specifies an array of strings, each listing a required OS feature (for example on Windows win32k
	OsFeatures *[]string `json:"os.features,omitempty"`
	// Variant - The optional variant field specifies a variant of the CPU, for example armv6l to specify a particular CPU variant of the ARM CPU.
	Variant *string `json:"variant,omitempty"`
	// Features - The optional features field specifies an array of strings, each listing a required CPU feature (for example sse4 or aes
	Features *[]string `json:"features,omitempty"`
}

// ReadCloser ...
type ReadCloser struct {
	autorest.Response `json:"-"`
	Value             *io.ReadCloser `json:"value,omitempty"`
}

// RefreshToken ...
type RefreshToken struct {
	autorest.Response `json:"-"`
	// RefreshToken - The refresh token to be used for generating access tokens
	RefreshToken *string `json:"refresh_token,omitempty"`
}

// Repositories list of repositories
type Repositories struct {
	autorest.Response `json:"-"`
	// Names - Repository names
	Names *[]string `json:"repositories,omitempty"`
}

// RepositoryAttributes repository attributes
type RepositoryAttributes struct {
	autorest.Response `json:"-"`
	// Registry - Registry name
	Registry *string `json:"registry,omitempty"`
	// ImageName - Image name
	ImageName *string `json:"imageName,omitempty"`
	// CreatedTime - Image created time
	CreatedTime *string `json:"createdTime,omitempty"`
	// LastUpdateTime - Image last update time
	LastUpdateTime *string `json:"lastUpdateTime,omitempty"`
	// ManifestCount - Number of the manifests
	ManifestCount *int32 `json:"manifestCount,omitempty"`
	// TagCount - Number of the tags
	TagCount *int32 `json:"tagCount,omitempty"`
	// ChangeableAttributes - Changeable attributes
	ChangeableAttributes *ChangeableAttributes `json:"changeableAttributes,omitempty"`
}

// RepositoryTags result of the request to list tags of the image
type RepositoryTags struct {
	// Name - Name of the image
	Name *string `json:"name,omitempty"`
	// Tags - List of tags
	Tags *[]string `json:"tags,omitempty"`
}

// SetObject ...
type SetObject struct {
	autorest.Response `json:"-"`
	Value             interface{} `json:"value,omitempty"`
}

// TagAttributes tag attributes
type TagAttributes struct {
	autorest.Response `json:"-"`
	// Registry - Registry name
	Registry *string `json:"registry,omitempty"`
	// ImageName - Image name
	ImageName *string `json:"imageName,omitempty"`
	// Attributes - List of tag attribute details
	Attributes *TagAttributesBase `json:"tag,omitempty"`
}

// TagAttributesBase tag attribute details
type TagAttributesBase struct {
	// Name - Tag name
	Name *string `json:"name,omitempty"`
	// Digest - Tag digest
	Digest *string `json:"digest,omitempty"`
	// CreatedTime - Tag created time
	CreatedTime *string `json:"createdTime,omitempty"`
	// LastUpdateTime - Tag last update time
	LastUpdateTime *string `json:"lastUpdateTime,omitempty"`
	// Signed - Is signed
	Signed *bool `json:"signed,omitempty"`
	// ChangeableAttributes - Changeable attributes
	ChangeableAttributes *ChangeableAttributes `json:"changeableAttributes,omitempty"`
}

// TagAttributesTag tag
type TagAttributesTag struct {
	// SignatureRecord - SignatureRecord value
	SignatureRecord *string `json:"signatureRecord,omitempty"`
}

// TagList list of tag details
type TagList struct {
	autorest.Response `json:"-"`
	// Registry - Registry name
	Registry *string `json:"registry,omitempty"`
	// ImageName - Image name
	ImageName *string `json:"imageName,omitempty"`
	// Tags - List of tag attribute details
	Tags *[]TagAttributesBase `json:"tags,omitempty"`
}

// V1Manifest returns the requested V1 manifest file
type V1Manifest struct {
	// Architecture - CPU architecture
	Architecture *string `json:"architecture,omitempty"`
	// Name - Image name
	Name *string `json:"name,omitempty"`
	// Tag - Image tag
	Tag *string `json:"tag,omitempty"`
	// FsLayers - List of layer information
	FsLayers *[]FsLayer `json:"fsLayers,omitempty"`
	// History - Image history
	History *[]History `json:"history,omitempty"`
	// Signatures - Image signature
	Signatures *[]ImageSignature `json:"signatures,omitempty"`
	// SchemaVersion - Schema version
	SchemaVersion *int32 `json:"schemaVersion,omitempty"`
}

// V2Manifest returns the requested Docker V2 Manifest file
type V2Manifest struct {
	// MediaType - Media type for this Manifest
	MediaType *string `json:"mediaType,omitempty"`
	// Config - V2 image config descriptor
	Config *Descriptor `json:"config,omitempty"`
	// Layers - List of V2 image layer information
	Layers *[]Descriptor `json:"layers,omitempty"`
	// SchemaVersion - Schema version
	SchemaVersion *int32 `json:"schemaVersion,omitempty"`
}
